<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderNoPayByParams(array $params)
 * @method syncReservationByParams(array $params)
 * @method refundCouponByParams(array $params)
 * @method releaseEmptyPointByParams(array $params)
 * @method modifyRefundForRefundChangeByParams(array $params)
 * @method batchSetThirdStaffAccountByParams(array $params)
 */
class Fix {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修复订单支付状态
     *
     * @support  string $no 订单号 [ require true ]
     * @support  string $payment_no 支付流水号 [ require true ]
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  string $reserve_time 预约时间（填写则修改预约时间） [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderNoPay () {
        return self::getClass()->orderNoPay([
        ]);
    }

    /**
     * 同步订单预约时间和排单表时间
     *
     * @support  string $store_ids 门店ids [ require true ]
     * @support  string $change_time 预约时间（预约时间在这个时间之后的订单，都会同步 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncReservation () {
        return self::getClass()->syncReservation([
        ]);
    }

    /**
     * 退券（含产品卡）
     *
     * @support  int $target_id 优惠券ID（或产品卡） [ require true ]
     * @support  int $user_id 用户ID [ require true ]
     * @support  string $type coupon 优惠券，product_card 产品卡 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundCoupon () {
        return self::getClass()->refundCoupon([
        ]);
    }

    /**
     * 释放无订单占点
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  string $end_date 截止时间 [ require true ]
     * @support  string $start_date 开始时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function releaseEmptyPoint () {
        return self::getClass()->releaseEmptyPoint([
        ]);
    }

    /**
     * 修改退款结果以兼容历史订单转退
     *
     * @support  int $refund_id 退款ID [ require true ]
     * @support  int $card_id 礼品卡ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyRefundForRefundChange () {
        return self::getClass()->modifyRefundForRefundChange([
        ]);
    }

    /**
     * 批量调整第三方账号
     *
     * @param  array $addStaffArray 创建的第三方员工信息 [ require false ]
     * @param  array $removeStaffIds 移除的第三方员工id列表 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchSetThirdStaffAccount (array $addStaffArray = [], array $removeStaffIds = []) {
        return self::getClass()->batchSetThirdStaffAccount([
            "addStaffArray" => $addStaffArray,
            "removeStaffIds" => $removeStaffIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Fix');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Fix');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}