<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method changePayTypeByParams(array $params)
 * @method listByParams(array $params)
 * @method closeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method getProductsInOrdersByParams(array $params)
 * @method closeByPaidByParams(array $params)
 * @method changeOrderStatusByParams(array $params)
 * @method logByParams(array $params)
 * @method invoiceByParams(array $params)
 */
class RetailOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 修改订单支付方式
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  string $payment_no 支付流水号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePayType (int $id, string $pay_type, string $payment_no = '') {
        return self::getClass()->changePayType([
            "id" => $id,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 订单列表
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 页内条数 [ require false ]
     * @support  string $user_phone 电话号码 [ require false ]
     * @support  string $paid_time_start 支付起始时间 [ require false ]
     * @support  string $paid_time_end 支付结束时间 [ require false ]
     * @support  string $user_name 用户姓名 [ require false ]
     * @support  string $order_no 订单号 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $status_list 状态列表 [ require false ]
     * @support  string $pay_type 支付方式 [ require false ]
     * @support  int $store_id 门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $id, string $reason) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_phone 用户手机号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeUserData () {
        return self::getClass()->changeUserData([
        ]);
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $order_no) {
        return self::getClass()->getIdByNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 根据订单ID获取订单号
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById (int $id) {
        return self::getClass()->getNoById([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单号获取订单下面买的产品
     *
     * @param  string $order_no 订单号 [ require false ]
     * @param  int $order_id 订单ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsInOrder (string $order_no = null, int $order_id = null) {
        return self::getClass()->getProductsInOrder([
            "order_no" => $order_no,
            "order_id" => $order_id,
        ]);
    }

    /**
     * 根据订单号批量获取订单下面买的产品
     *
     * @param  array $order_nos 订单号数组 [ require true ]
     * @param  array $order_ids 订单ID数组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsInOrders (array $order_nos = [], array $order_ids = []) {
        return self::getClass()->getProductsInOrders([
            "order_nos" => $order_nos,
            "order_ids" => $order_ids,
        ]);
    }

    /**
     * 关闭订单——已支付的零售订单
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $reason 关闭原因 [ require true ]
     * @support  int $operateId 操作伙伴ID(后台操作时必须添加) [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeByPaid () {
        return self::getClass()->closeByPaid([
        ]);
    }

    /**
     * 修改订单的状态
     *
     * @support  int $id id [ require true ]
     * @support  string $status 订单状态: submitted(未支付)，paid(已支付) [ require false ]
     * @support  int $operateId 录入伙伴ID(后台操作时必须添加) [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeOrderStatus () {
        return self::getClass()->changeOrderStatus([
        ]);
    }

    /**
     * 查询订单操作日志
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function log (int $id) {
        return self::getClass()->log([
            "id" => $id,
        ]);
    }

    /**
     * 根据零售订单id查询发票信息
     *
     * @param  int $id 零售订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function invoice (int $id) {
        return self::getClass()->invoice([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\RetailOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\RetailOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}