<?php
namespace Mainto\Bridge\Invokes\HimoProduct\GuestPiece;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method guestPieceListByParams(array|\Mainto\Bridge\Structs\HimoProduct\GuestPiece\Cmd\GuestPieceListCmd $params)
 * @method addGuestPieceRecordByParams(array $params)
 */
class GuestPiece {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 客资列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\GuestPiece\Cmd\GuestPieceListCmd $guestPieceListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\GuestPiece\DTO\GuestPieceListDTO
     */
    public static function guestPieceList (\Mainto\Bridge\Structs\HimoProduct\GuestPiece\Cmd\GuestPieceListCmd $guestPieceListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->guestPieceList($guestPieceListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\GuestPiece\DTO\GuestPieceListDTO"
        );
    }


    /**
     * 添加回访记录
     *
     * @param  string $guestPieceId 客资Id [ require true ]
     * @param  string $visitRecord 回访记录 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addGuestPieceRecord (string $guestPieceId, string $visitRecord) {
        return self::getClass()->addGuestPieceRecord([
            "guestPieceId" => $guestPieceId,
            "visitRecord" => $visitRecord,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'GuestPiece\GuestPiece');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'GuestPiece\GuestPiece');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}