<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Campaign;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method initCampaignByParams(array $params)
 * @method saveCampaignPreviewTemplateByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPreviewCmd $params)
 * @method saveCampaignTemplateByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignSaveCmd $params)
 * @method getCampaignTemplateDetailByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDetailCmd $params)
 * @method getCampaignListByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignListCmd $params)
 * @method updateCampaignStatusByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignStatusCmd $params)
 * @method campaignDeleteByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDeleteCmd $params)
 * @method cronCampaignUpByParams(array $params)
 * @method cronCampaignDownByParams(array $params)
 */
class Campaign {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 初始化活动
     *
     * @throws  \Exception
     * @return  int
     */
    public static function initCampaign () {
        return self::getClass()->initCampaign();
    }

    /**
     * 保存预览模版
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPreviewCmd $campaignPreviewCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function saveCampaignPreviewTemplate (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPreviewCmd $campaignPreviewCmd) {
        return self::getClass()->saveCampaignPreviewTemplate($campaignPreviewCmd);
    }


    /**
     * 保存模版
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignSaveCmd $campaignSaveCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function saveCampaignTemplate (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignSaveCmd $campaignSaveCmd) {
        return self::getClass()->saveCampaignTemplate($campaignSaveCmd);
    }


    /**
     * 获取活动模版详情
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDetailCmd $campaignDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignDetailDTO
     */
    public static function getCampaignTemplateDetail (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDetailCmd $campaignDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCampaignTemplateDetail($campaignDetailCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignDetailDTO"
        );
    }


    /**
     * 承接页活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignListCmd $campaignListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignListDTO
     */
    public static function getCampaignList (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignListCmd $campaignListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCampaignList($campaignListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignListDTO"
        );
    }


    /**
     * 上/下线
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignStatusCmd $campaignStatusCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCampaignStatus (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignStatusCmd $campaignStatusCmd) {
        return self::getClass()->updateCampaignStatus($campaignStatusCmd);
    }


    /**
     * 删除模版
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDeleteCmd $campaignDeleteCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function campaignDelete (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDeleteCmd $campaignDeleteCmd) {
        return self::getClass()->campaignDelete($campaignDeleteCmd);
    }


    /**
     * 定时上线模版
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cronCampaignUp () {
        return self::getClass()->cronCampaignUp();
    }

    /**
     * 定时下线模版
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cronCampaignDown () {
        return self::getClass()->cronCampaignDown();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Campaign\Campaign');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Campaign\Campaign');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}