<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Campaign;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method campaignInitByParams(array $params)
 * @method campaignPreviewByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPreviewCmd $params)
 * @method campaignSaveByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignSaveCmd $params)
 * @method campaignDetailByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDetailCmd $params)
 * @method campaignListByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignListCmd $params)
 * @method campaignStatusByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignStatusCmd $params)
 * @method campaignDeleteByParams(array|\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDeleteCmd $params)
 * @method cronCampaignUpByParams(array $params)
 * @method cronCampaignDownByParams(array $params)
 */
class Campaign {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 初始化活动
     *
     * @throws  \Exception
     * @return  int
     */
    public static function campaignInit () {
        return self::getClass()->campaignInit();
    }

    /**
     * 保存预览模版
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPreviewCmd $campaignPreviewCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function campaignPreview (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignPreviewCmd $campaignPreviewCmd) {
        return self::getClass()->campaignPreview($campaignPreviewCmd);
    }


    /**
     * 保存模版
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignSaveCmd $campaignSaveCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function campaignSave (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignSaveCmd $campaignSaveCmd) {
        return self::getClass()->campaignSave($campaignSaveCmd);
    }


    /**
     * 获取活动模版详情
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDetailCmd $campaignDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignDetailDTO
     */
    public static function campaignDetail (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDetailCmd $campaignDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->campaignDetail($campaignDetailCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignDetailDTO"
        );
    }


    /**
     * 承接页活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignListCmd $campaignListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignListDTO
     */
    public static function campaignList (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignListCmd $campaignListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->campaignList($campaignListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Campaign\DTO\CampaignListDTO"
        );
    }


    /**
     * 上/下线
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignStatusCmd $campaignStatusCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function campaignStatus (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignStatusCmd $campaignStatusCmd) {
        return self::getClass()->campaignStatus($campaignStatusCmd);
    }


    /**
     * 删除模版
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDeleteCmd $campaignDeleteCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function campaignDelete (\Mainto\Bridge\Structs\HimoProduct\Campaign\Cmd\CampaignDeleteCmd $campaignDeleteCmd) {
        return self::getClass()->campaignDelete($campaignDeleteCmd);
    }


    /**
     * 定时上线模版
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cronCampaignUp () {
        return self::getClass()->cronCampaignUp();
    }

    /**
     * 定时下线模版
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cronCampaignDown () {
        return self::getClass()->cronCampaignDown();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Campaign\Campaign');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Campaign\Campaign');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}