<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method treeByParams(array $params)
 * @method getTreeByUseTypeByParams(array $params)
 * @method listByParams(array $params)
 * @method getInfoByUseTypeAndIdsByParams(array $params)
 * @method detailByParams(array $params)
 * @method addByParams(array $params)
 * @method editByParams(array $params)
 * @method startByParams(array $params)
 * @method closeByParams(array $params)
 * @method getTopTagByParams(array $params)
 * @method getUseTypeByParams(array $params)
 */
class PictureTags {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 标签树
     *
     * @support  bool $with_delete 是否包含未启用的数据 [ require false ]
     * @support  int $id 标签id(查询该标签及所有子级标签) [ require false ]
     * @support  string $use_type 使用类型，默认样片池标签 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\PictureTagsTreeDto[]
     */
    public static function tree () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->tree([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\PictureTagsTreeDto[]"
        );
    }

    /**
     * 通过useType获取标签树
     *
     * @support  bool $with_delete 是否包含未启用的数据 [ require false ]
     * @support  string $use_type 使用类型，默认样片池标签 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\PictureTagsTreeDto[]
     */
    public static function getTreeByUseType () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getTreeByUseType([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\PictureTagsTreeDto[]"
        );
    }

    /**
     * 标签列表
     *
     * @support  int $id 标签id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @support  string $use_type 使用类型，默认样片池标签 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\PictureTagsListDto
     */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\PictureTagsListDto"
        );
    }

    /**
     * 通过使用类型和ids获取标签信息
     *
     * @support  array $ids 标签ids [ require true ]
     * @support  string $use_type 使用类型，默认样片池标签 [ require false ]
     * @support  bool $with_delete 是否包含未启用的数据 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\PictureTagsDetailDto[]
     */
    public static function getInfoByUseTypeAndIds () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getInfoByUseTypeAndIds([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\PictureTagsDetailDto[]"
        );
    }

    /**
     * 标签详情
     *
     * @support  int $id 标签id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\PictureTagsDetailDto
     */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\PictureTagsDetailDto"
        );
    }

    /**
     * 标签添加
     *
     * @support  int $parent_id 标签归属（父级id） [ require false ]
     * @support  string $name 标签名称 [ require true ]
     * @support  int $weight 权重 [ require false ]
     * @support  string $description 描述 [ require false ]
     * @support  string $use_type 使用类型，默认样片池标签 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function add () {
        return self::getClass()->add([
        ]);
    }

    /**
     * 标签修改
     *
     * @support  int $id 标签id [ require true ]
     * @support  int $parent_id 标签归属（父级id） [ require false ]
     * @support  string $name 标签名称 [ require true ]
     * @support  int $weight 权重 [ require false ]
     * @support  string $description 描述 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function edit () {
        return self::getClass()->edit([
        ]);
    }

    /**
     * 标签启用
     *
     * @support  int $id 标签id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function start () {
        return self::getClass()->start([
        ]);
    }

    /**
     * 标签停用
     *
     * @support  int $id 标签id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close () {
        return self::getClass()->close([
        ]);
    }

    /**
     * 获得一级标签
     *
     * @support  string $useType 使用类型，默认样片池标签 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTopTag () {
        return self::getClass()->getTopTag([
        ]);
    }

    /**
     * 获取useType
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\UseTypeDto[]
     */
    public static function getUseType () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUseType(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\PictureTags\Dto\UseTypeDto[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PictureTags');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PictureTags');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}