<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUnfinishedActivitiesSelectByParams(array $params)
 * @method getActivityProductTreeByParams(array $params)
 */
class CrmActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取未结束的活动下拉
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\CrmActivity\Dto\UnfinishedActivitiesDto[]
     */
    public static function getUnfinishedActivitiesSelect () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUnfinishedActivitiesSelect(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\CrmActivity\Dto\UnfinishedActivitiesDto[]"
        );
    }

    /**
     * 获取活动下的产品树结构
     *
     * @param  int $activityId 活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivityProductTree (int $activityId) {
        return self::getClass()->getActivityProductTree([
            "activityId" => $activityId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\CrmActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\CrmActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}