<?php
namespace Mainto\Bridge\Invokes\HimoProduct\ABTest;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addABTestStoreByParams(array|\Mainto\Bridge\Structs\HimoProduct\ABTest\Cmd\ABTestStoreCmd $params)
 * @method removeABTestStoreByParams(array|\Mainto\Bridge\Structs\HimoProduct\ABTest\Cmd\ABTestStoreCmd $params)
 */
class ABTest {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加ABTest门店
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\ABTest\Cmd\ABTestStoreCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addABTestStore (\Mainto\Bridge\Structs\HimoProduct\ABTest\Cmd\ABTestStoreCmd $cmd) {
        return self::getClass()->addABTestStore($cmd);
    }


    /**
     * 移除ABTest门店
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\ABTest\Cmd\ABTestStoreCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function removeABTestStore (\Mainto\Bridge\Structs\HimoProduct\ABTest\Cmd\ABTestStoreCmd $cmd) {
        return self::getClass()->removeABTestStore($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'ABTest\ABTest');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'ABTest\ABTest');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}