<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method detailByParams(array $params)
 */
class PreferentialTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建优惠券模板
     *
     * @support  string $name 优惠名称 [ require true ]
     * @support  array $extend 拓展信息 [ require false ]
     * @support  string $apply_in 使用模块 [ require false ]
     * @support  string $type 优惠类型(discount_coupon[折扣优惠],decrease_coupon[减价优惠],product_coupon[产品优惠]) [ require true ]
     * @support  array $limit 优惠限制产品/门店 [ require false ]
     * @support  int $action_scope 是否包含sku [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 更新优惠券模板
     *
     * @support  int $id 优惠模板id [ require true ]
     * @support  string $name 优惠名称 [ require false ]
     * @support  array $extend 拓展信息 [ require false ]
     * @support  array $limit 优惠限制 [ require false ]
     * @support  bool $is_released 是否上线 [ require false ]
     * @support  string $apply_in 使用模块 [ require false ]
     * @support  int $action_scope 是否包含sku [ require false ]
     * @support  float $discount 折扣 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 获取优惠券模板列表(分页)
     *
     * @support  array $ids 模板ids [ require false ]
     * @support  string $name 优惠名称 [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  string $apply_in 使用模块 [ require false ]
     * @support  int $create_by 创建人 [ require false ]
     * @support  int $page 分页 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 获取优惠券模板列表(所有)
     *
     * @support  string $name 优惠名称 [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  string $apply_in 使用模块 [ require false ]
     * @support  bool $with_types 是否包含类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all([
        ]);
    }

    /**
     * 获取优惠券模板信息
     *
     * @param  int $id 优惠券模板id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PreferentialTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PreferentialTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}