<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method staffInfoByParams(array $params)
 * @method currentStoreByParams(array $params)
 * @method selectStoreByParams(array $params)
 * @method affiliateInfoByParams(array $params)
 * @method getKidsAuthListByParams(array $params)
 * @method loginByParams(array $params)
 * @method logOutByParams(array $params)
 * @method getLoginCodeByParams(array $params)
 */
class Auth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取管理员信息
     *
     * @support  string $staffName 姓名或花名 [ require false ]
     * @support  string $type 类型(core总部|himo_store门店) [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function staffInfo () {
        return self::getClass()->staffInfo([
        ]);
    }

    /**
     * 获取当前门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function currentStore () {
        return self::getClass()->currentStore();
    }

    /**
     * 设置当前门店
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function selectStore () {
        return self::getClass()->selectStore([
        ]);
    }

    /**
     * 获取加盟商信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function affiliateInfo () {
        return self::getClass()->affiliateInfo();
    }

    /**
     * 获取kids系统权限列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getKidsAuthList () {
        return self::getClass()->getKidsAuthList();
    }

    /**
     * bmsApp 持久化登陆
     *
     * @param  string $code 登录token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function login (string $code) {
        return self::getClass()->login([
            "code" => $code,
        ]);
    }

    /**
     * bmsApp 退出
     *
     * @support  string $deviceUniqueNo 设备唯一编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function logOut () {
        return self::getClass()->logOut([
        ]);
    }

    /**
     * 获取 App 持久化 Code
     *
     * @support  string $deviceUniqueNo 设备唯一编号 [ require true ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLoginCode () {
        return self::getClass()->getLoginCode([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Auth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Auth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}