<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method announcementPublisherByParams(array $params)
 * @method announcementListByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementSearch $params)
 * @method announcementListWithPageByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementSearch $params)
 * @method createAnnouncementByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementCreate $params)
 * @method editAnnouncementByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementEdit $params)
 * @method announcementDetailByParams(array $params)
 * @method abolishByParams(array $params)
 * @method exportReadReportByParams(array $params)
 * @method getPopsByParams(array $params)
 * @method readAnnouncementByParams(array $params)
 * @method getWaitReadMessagesByParams(array $params)
 * @method createAnnouncementCategoryByParams(array $params)
 * @method editAnnouncementCategoryByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementCategoryEdit $params)
 * @method deleteAnnouncementCategoryByParams(array $params)
 * @method getAnnouncementCategoryByParams(array $params)
 * @method departmentTreeByParams(array $params)
 */
class Announcement {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取公告发布人
     *
     * @throws  \Exception
     * @return  array
     */
    public static function announcementPublisher () {
        return self::getClass()->announcementPublisher();
    }

    /**
     * 获取公告列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementSearch $announcementSearchCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement[]
     */
    public static function announcementList (\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementSearch $announcementSearchCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->announcementList($announcementSearchCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\Announcement[]"
        );
    }


    /**
     * 获取公告列表(分页)
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementSearch $announcementSearchCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementListWithPage
     */
    public static function announcementListWithPage (\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementSearch $announcementSearchCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->announcementListWithPage($announcementSearchCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementListWithPage"
        );
    }


    /**
     * 创建公告
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementCreate $announcementCreateCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAnnouncement (\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementCreate $announcementCreateCmd) {
        return self::getClass()->createAnnouncement($announcementCreateCmd);
    }


    /**
     * 编辑公告
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementEdit $announcementEditCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function editAnnouncement (\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementEdit $announcementEditCmd) {
        return self::getClass()->editAnnouncement($announcementEditCmd);
    }


    /**
     * 公告详情
     *
     * @param  int $id 公告id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementAppendInfo
     */
    public static function announcementDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->announcementDetail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementAppendInfo"
        );
    }

    /**
     * 作废公告
     *
     * @param  int $id 公告id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function abolish (int $id) {
        return self::getClass()->abolish([
            "id" => $id,
        ]);
    }

    /**
     * 导出公告阅读报告
     *
     * @param  array $messageIds 公告id列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function exportReadReport (array $messageIds) {
        return self::getClass()->exportReadReport([
            "messageIds" => $messageIds,
        ]);
    }

    /**
     * 获取指定日期的弹窗
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPops (string $date) {
        return self::getClass()->getPops([
            "date" => $date,
        ]);
    }

    /**
     * 读公告
     *
     * @param  int $reader 读者id [ require true ]
     * @param  int $messageId 板块名称 [ require true ]
     * @param  string $readerType 读者类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function readAnnouncement (int $reader, int $messageId, string $readerType) {
        return self::getClass()->readAnnouncement([
            "reader" => $reader,
            "messageId" => $messageId,
            "readerType" => $readerType,
        ]);
    }

    /**
     * 获取未读消息ids
     *
     * @param  int $reader 读取人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWaitReadMessages (int $reader) {
        return self::getClass()->getWaitReadMessages([
            "reader" => $reader,
        ]);
    }

    /**
     * 创建公告板块
     *
     * @param  string $name 板块名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createAnnouncementCategory (string $name) {
        return self::getClass()->createAnnouncementCategory([
            "name" => $name,
        ]);
    }

    /**
     * 编辑公告板块
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementCategoryEdit $categoryCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function editAnnouncementCategory (\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\Cmd\AnnouncementCategoryEdit $categoryCmd) {
        return self::getClass()->editAnnouncementCategory($categoryCmd);
    }


    /**
     * 删除公告板块
     *
     * @param  int $id 公告id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteAnnouncementCategory (int $id) {
        return self::getClass()->deleteAnnouncementCategory([
            "id" => $id,
        ]);
    }

    /**
     * 获取公告板块
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementCategory[]
     */
    public static function getAnnouncementCategory () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAnnouncementCategory(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Announcement\DTO\AnnouncementCategory[]"
        );
    }

    /**
     * 获取公告部门树
     *
     * @support  int $beginDepartmentId 起始部门id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function departmentTree () {
        return self::getClass()->departmentTree([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Announcement');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Announcement');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}