<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLogsByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method cancelAuditByParams(array $params)
 * @method codeListByParams(array $params)
 * @method codeAllByParams(array $params)
 * @method abolishByParams(array $params)
 */
class InteriorCoupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 开单码创建记录查询
     *
     * @support  array $ids 记录ids [ require false ]
     * @support  int $create_by 创建人 [ require false ]
     * @support  string $status 审批状态 [ require true ]
     * @support  string $created_at_end 创建时间止 [ require false ]
     * @support  string $created_at_start 创建时间起 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLogs () {
        return self::getClass()->getLogs([
        ]);
    }

    /**
     * 开单码管理-详情
     *
     * @support  int $audit_id 申请记录id [ require false ]
     * @support  int $create_log_id 创券记录id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 开单码管理-申请制券
     *
     * @support  int $audit_id 审批记录id,编辑时必传 [ require false ]
     * @support  int $act_id 活动ID [ require false ]
     * @support  int $count 创建数量 [ require false ]
     * @support  float $money 单个优惠金额 [ require true ]
     * @support  array $extend 拓展信息 [ require true ]
     * @support  string $stop_usage 过期时间 [ require true ]
     * @support  int $sale_store_id 购买门店id，售卖渠道为门店必填 [ require false ]
     * @support  float $pay_money 实际支付 [ require false ]
     * @support  int $channel_id 渠道 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 开单码管理-撤回审批
     *
     * @support  int $audit_id 审核记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelAudit () {
        return self::getClass()->cancelAudit([
        ]);
    }

    /**
     * 获取开单折扣码列表(分页)
     *
     * @support  int $create_log_id 记录id [ require true ]
     * @support  array $uuids 开单折扣码 [ require false ]
     * @support  array $multi_status 状态列表 [ require false ]
     * @support  string $used_at_start 使用时间起 [ require false ]
     * @support  string $used_at_end 使用时间止 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function codeList () {
        return self::getClass()->codeList([
        ]);
    }

    /**
     * 获取开单折扣码列表(分页)
     *
     * @support  int $create_log_id 记录id [ require true ]
     * @support  array $multi_status 状态列表 [ require false ]
     * @support  array $uuids 开单折扣码 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function codeAll () {
        return self::getClass()->codeAll([
        ]);
    }

    /**
     * 作废开单折扣码
     *
     * @support  int $id 开单折扣码id [ require true ]
     * @support  array $extend 码数组 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function abolish () {
        return self::getClass()->abolish([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Marketing\InteriorCoupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Marketing\InteriorCoupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}