<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getDouyinMerchantListByParams(array $params)
 * @method addDouyinMerchantByParams(array $params)
 * @method getDouyinMerchantDetailByParams(array $params)
 * @method checkDouyinPermissionByParams(array $params)
 */
class DouyinMerchant {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 抖音进件列表
     *
     * @param  string $name 商户名称 [ require false ]
     * @param  string $douyinMerchantId 商户号 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantListDTO
     */
    public static function getDouyinMerchantList (string $name = '', string $douyinMerchantId = '') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getDouyinMerchantList([
                            "name" => $name,
                            "douyinMerchantId" => $douyinMerchantId,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantListDTO"
        );
    }

    /**
     * 抖音-新增进件
     *
     * @param  string $name 商户名称 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantDTO
     */
    public static function addDouyinMerchant (string $name) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->addDouyinMerchant([
                            "name" => $name,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantDTO"
        );
    }

    /**
     * 抖音-进件详情
     *
     * @param  string $merchantId 自定义商户号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantDTO
     */
    public static function getDouyinMerchantDetail (string $merchantId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getDouyinMerchantDetail([
                            "merchantId" => $merchantId,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\User\DTO\DouyinMerchant\DouyinMerchantDTO"
        );
    }

    /**
     * 抖音-用户校验更新权限
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function checkDouyinPermission () {
        return self::getClass()->checkDouyinPermission();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\DouyinMerchant');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\DouyinMerchant');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}