<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method auditByParams(array $params)
 * @method uperSelectByParams(array $params)
 * @method allUperSelectByParams(array $params)
 * @method addByParams(array $params)
 */
class UnreviewedSamplePhotos {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取样片审核列表
     *
     * @support  array $product_ids 产品ids [ require false ]
     * @support  int $uper 上传人id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedSamplePhotos\Dto\ListDto
     */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\UnreviewedSamplePhotos\Dto\ListDto"
        );
    }

    /**
     * 样片批量审核
     *
     * @support  array $ids 样片ids [ require true ]
     * @support  array $tags 标签ids [ require false ]
     * @support  string $result 结果[pass, not_pass] [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function audit () {
        return self::getClass()->audit([
        ]);
    }

    /**
     * 样片待处理上传人下拉框
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\SelectDto[]
     */
    public static function uperSelect () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->uperSelect(),
            "\Mainto\Bridge\Structs\HimoProduct\SelectDto[]"
        );
    }

    /**
     * 全部上传人下拉
     *
     * @throws  \Exception
     * @return  array
     */
    public static function allUperSelect () {
        return self::getClass()->allUperSelect();
    }

    /**
     * 样片上传
     *
     * @support  string $brand 品牌 [ require true ]
     * @support  array $product_ids 产品ids [ require true ]
     * @support  string $expired_at 过期时间 [ require true ]
     * @support  array $images 样片地址 [ require true ]
     * @support  array $types 样片类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function add () {
        return self::getClass()->add([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\UnreviewedSamplePhotos');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\UnreviewedSamplePhotos');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}