<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method signByParams(array $params)
 * @method configCreateByParams(array $params)
 */
class Files {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * sign
     *
     * @param  string $upyun_key 需要签名的又拍云key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sign (string $upyun_key) {
        return self::getClass()->sign([
            "upyun_key" => $upyun_key,
        ]);
    }

    /**
     * configCreate
     *
     * @support  string $upyun_key upyun_key [ require true ]
     * @support  string $prefix 路径 [ require true ]
     * @support  string $save_key 保存key [ require true ]
     * @support  string $bucket 空间名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function configCreate () {
        return self::getClass()->configCreate([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Files');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Files');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}