<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method editByParams(array $params)
 * @method accessTokenByParams(array $params)
 * @method checkOpenIdByParams(array $params)
 * @method checkPhoneByParams(array $params)
 * @method changePasswardByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增一个用户
     *
     * @support  string $phone 手机号 [ require true ]
     * @support  string $sex 性别 male|female [ require true ]
     * @support  string $password 密码 [ require true ]
     * @support  string $union_id 用户union_id [ require false ]
     * @support  string $head_img 头像 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 获取用户信息
     *
     * @support  string $phone 手机号 [ require false ]
     * @support  string $union_id 用户open_id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 修改用户信息
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  string $token token [ require true ]
     * @support  string $phone 手机号 [ require false ]
     * @support  string $sex 性别 [ require false ]
     * @support  string $name 用户名 [ require false ]
     * @support  string $head_sculpture 头像 [ require false ]
     * @support  string $birth 生日 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit () {
        return self::getClass()->edit([
        ]);
    }

    /**
     * 获取access token
     *
     * @param  string $scene 项目 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function accessToken (string $scene) {
        return self::getClass()->accessToken([
            "scene" => $scene,
        ]);
    }

    /**
     * 通过openid验证登录
     *
     * @support  string $open_id open_id [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOpenId () {
        return self::getClass()->checkOpenId([
        ]);
    }

    /**
     * 通过手机号验证登录
     *
     * @support  string $phone 顾客手机号 [ require true ]
     * @support  string $password 密码 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkPhone () {
        return self::getClass()->checkPhone([
        ]);
    }

    /**
     * 重置密码
     *
     * @support  string $phone 顾客手机号 [ require true ]
     * @support  string $password 新密码 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePassward () {
        return self::getClass()->changePassward([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Extend\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Extend\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}