<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createCountBackwardsSequenceByParams(array $params)
 * @method deleteCountBackwardsSequenceByParams(array $params)
 * @method downByParams(array $params)
 * @method getCurrentByParams(array $params)
 * @method setCurrentByParams(array $params)
 * @method cancelReservationToolByParams(array $params)
 */
class Tools {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建一个倒数序列
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  int $start 初始化剩余个数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createCountBackwardsSequence (string $name, int $start) {
        return self::getClass()->createCountBackwardsSequence([
            "name" => $name,
            "start" => $start,
        ]);
    }

    /**
     * 删除一个倒数序列
     *
     * @param  string $name 序列名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteCountBackwardsSequence (string $name) {
        return self::getClass()->deleteCountBackwardsSequence([
            "name" => $name,
        ]);
    }

    /**
     * 进行倒数
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  int $downNum 减掉几个 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function down (string $name, int $downNum = 1) {
        return self::getClass()->down([
            "name" => $name,
            "downNum" => $downNum,
        ]);
    }

    /**
     * 获得当前倒数剩余
     *
     * @param  string $name 序列名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCurrent (string $name) {
        return self::getClass()->getCurrent([
            "name" => $name,
        ]);
    }

    /**
     * 设置当前倒数剩余
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  int $amount 数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setCurrent (string $name, int $amount) {
        return self::getClass()->setCurrent([
            "name" => $name,
            "amount" => $amount,
        ]);
    }

    /**
     * 强制取消排单表占点
     *
     * @param  int $id 订单ID [ require false ]
     * @param  string $orderNo 订单编号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelReservationTool (int $id = null, string $orderNo = null) {
        return self::getClass()->cancelReservationTool([
            "id" => $id,
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Tools');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Tools');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}