<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method editByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Subcompany {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增子公司
     *
     * @support  string $name 公司名称 [ require false ]
     * @support  string $taxnum 税号 [ require false ]
     * @support  string $address 注册地址及电话 [ require false ]
     * @support  string $account 开户行及账号 [ require false ]
     * @support  string $phone 销方电话 [ require false ]
     * @support  string $receive_people 收款人 [ require false ]
     * @support  string $check_people 复核人 [ require false ]
     * @support  string $billing_people 开票员 [ require false ]
     * @support  string $verify_code 校验码 [ require false ]
     * @support  string $key 加密KEY [ require false ]
     * @support  string $value 加密VALUE [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add([
        ]);
    }

    /**
     * 查询子公司(带分页)
     *
     * @support  int $id 公司id [ require false ]
     * @param  string $name 公司名称 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (string $name = '', int $page = 1, int $page_size = 15) {
        return self::getClass()->list([
            "name" => $name,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 查询子公司(不带分页)
     *
     * @support  int $id 公司id [ require false ]
     * @param  string $name 公司名称 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function all (string $name = '') {
        return self::getClass()->all([
            "name" => $name,
        ]);
    }

    /**
     * 编辑子公司
     *
     * @support  int $id 公司id [ require true ]
     * @support  string $name 公司名称 [ require false ]
     * @support  string $taxnum 税号 [ require false ]
     * @support  string $address 注册地址及电话 [ require false ]
     * @support  string $account 开户行及账号 [ require false ]
     * @support  string $phone 销方电话 [ require false ]
     * @support  string $receive_people 收款人 [ require false ]
     * @support  string $check_people 复核人 [ require false ]
     * @support  string $billing_people 开票员 [ require false ]
     * @support  string $verify_code 校验码 [ require false ]
     * @support  string $key 加密KEY [ require false ]
     * @support  string $value 加密VALUE [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit () {
        return self::getClass()->edit([
        ]);
    }

    /**
     * 删除子公司
     *
     * @param  int $id 公司id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Subcompany');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Subcompany');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}