<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method detailByParams(array $params)
 * @method cancelByParams(array $params)
 * @method createUpgradeSkuByParams(array $params)
 * @method orderDiffSuccessHookByParams(array|\Mainto\Bridge\Structs\HimoProduct\Order\Message\Dto\OrderModifyOrderSaleCmd $params)
 * @method orderDiffCancelHookByParams(array|\Mainto\Bridge\Structs\HimoProduct\Order\Message\Dto\OrderModifyCancelCmd $params)
 * @method getNewOrderIdByOrderDiffIdByParams(array $params)
 */
class OrderDiff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建一个订单修改(订单完成前)
     *
     * @support  int $orderId 订单ID [ require false ]
     * @support  int $userId 用户ID [ require false ]
     * @support  string $userName 用户名 [ require false ]
     * @support  string $userPhone 用户手机号 [ require false ]
     * @support  string $userSex 用户性别 [ require false ]
     * @support  string $userBirthday 用户生日 [ require false ]
     * @support  float $money 订单金额 [ require true ]
     * @support  float $realMoney 订单实际金额(做校验用) [ require true ]
     * @support  float $needPaidMoney 订单待支付金额 [ require true ]
     * @support  array $productInfo 订单详情 [ require false ]
     * @support  int $reachedPeopleNum 实际到店人数 [ require false ]
     * @support  string $interiorCouponCode 开单折扣码UUID [ require false ]
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [ require false ]
     * @support  int $couponId 优惠券ID [ require false ]
     * @support  float $couponDeductionMoney 优惠券抵扣金额 [ require false ]
     * @support  int $productCardId 产品卡ID [ require false ]
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [ require false ]
     * @support  float $specialDiscountMoney 特殊折扣金额 [ require false ]
     * @support  string $discountType 特殊折扣类型 [ require false ]
     * @support  string $discountNote 特殊折扣备注 [ require false ]
     * @support  int $specialDiscountStaffId 特殊折扣使用的伙伴id [ require false ]
     * @support  string $reserveTime 预约时间 [ require false ]
     * @support  string $type 订单类型 [ require true ]
     * @support  string $note 订单备注 [ require false ]
     * @support  string $module 模块 [ require false ]
     * @support  array $retailProducts 零售产品数组 [ require false ]
     * @support  array $packageDiscountIds 套餐优惠信息 [ require false ]
     * @support  float $packageDiscountMoney 套餐优惠金额 [ require false ]
     * @support  float $weekdayDiscountMoney 周间优惠金额 [ require false ]
     * @support  bool $isChangeStore 是否转门店 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 设置diff订单完成支付
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  int $orderDiffId order_diff的id [ require true ]
     * @support  string $diffType 类型:upgrade和order [ require true ]
     * @support  string $payType 支付类型 [ require true ]
     * @support  string $paymentNo 支付流水号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPaid () {
        return self::getClass()->setPaid([
        ]);
    }

    /**
     * 获取diff详情
     *
     * @support  int $orderDiffId 订单diff的ID [ require true ]
     * @support  string $diffType 类型:upgrade和order [ require true ]
     * @support  bool $showCancel 是否显示取消的修改信息（会显示最新一个取消的修改信息) [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 取消未支付订单
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  int $orderDiffId order_diff的id [ require true ]
     * @support  string $reason 取消原因(取消修改和重新编辑) [ require true ]
     * @support  string $diffType 类型:upgrade和order [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel([
        ]);
    }

    /**
     * 完成订单之后添加加修加印产品
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  float $money 订单金额 [ require true ]
     * @support  float $realMoney 订单实际支付金额 [ require false ]
     * @support  array $productInfo 订单详情(无需完成前的订单信息) [ require false ]
     * @support  int $couponId 优惠券ID [ require false ]
     * @support  float $couponDeductionMoney 优惠券抵扣金额 [ require false ]
     * @support  int $productCardId 产品卡ID [ require false ]
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [ require false ]
     * @support  float $specialDiscountMoney 特殊折扣金额 [ require false ]
     * @support  string $discountType 特殊折扣类型 [ require false ]
     * @support  string $discountNote 特殊折扣备注 [ require false ]
     * @support  int $specialDiscountStaffId 特殊折扣使用的伙伴id [ require false ]
     * @support  int $inputStaffId 伙伴id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createUpgradeSku () {
        return self::getClass()->createUpgradeSku([
        ]);
    }

    /**
     * 订单Diff支付成功回调
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Order\Message\Dto\OrderModifyOrderSaleCmd $orderModifyOrderSaleCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderDiffSuccessHook (\Mainto\Bridge\Structs\HimoProduct\Order\Message\Dto\OrderModifyOrderSaleCmd $orderModifyOrderSaleCmd) {
        return self::getClass()->orderDiffSuccessHook($orderModifyOrderSaleCmd);
    }


    /**
     * 订单Diff支付失败回调
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Order\Message\Dto\OrderModifyCancelCmd $orderModifyCancelCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderDiffCancelHook (\Mainto\Bridge\Structs\HimoProduct\Order\Message\Dto\OrderModifyCancelCmd $orderModifyCancelCmd) {
        return self::getClass()->orderDiffCancelHook($orderModifyCancelCmd);
    }


    /**
     * 通过orderDiffId获取转门店后的新orderId
     *
     * @param  int $orderDiffId 订单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\GetNewOrderIdByOrderDiffIdDto
     */
    public static function getNewOrderIdByOrderDiffId (int $orderDiffId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getNewOrderIdByOrderDiffId([
                            "orderDiffId" => $orderDiffId,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\GetNewOrderIdByOrderDiffIdDto"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\OrderDiff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\OrderDiff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}