<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLogsByParams(array $params)
 * @method detailByParams(array $params)
 * @method createPhysicalByParams(array|\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ProductCardPhysicalCmd $params)
 * @method createVirtualByParams(array|\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ProductCardCmd $params)
 * @method cancelAuditByParams(array $params)
 * @method codeListByParams(array $params)
 * @method codeAllByParams(array $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品卡创建记录查询
     *
     * @support  array $ids 记录ids [ require false ]
     * @support  bool $with_template_info 包含模板信息 [ require false ]
     * @support  string $apply_in 应用于(蓝标/大师等) [ require false ]
     * @support  int $create_by 创建人 [ require false ]
     * @support  string $status 审批状态 [ require true ]
     * @support  string $created_at_end 创建时间止 [ require false ]
     * @support  string $created_at_start 创建时间起 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLogs () {
        return self::getClass()->getLogs([
        ]);
    }

    /**
     * 产品卡管理-详情
     *
     * @support  int $audit_id 申请记录id [ require false ]
     * @support  int $create_log_id 创券记录id [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 产品卡管理-创建实体卡-无需审批
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ProductCardPhysicalCmd $productCardPhysicalCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPhysical (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ProductCardPhysicalCmd $productCardPhysicalCmd) {
        return self::getClass()->createPhysical($productCardPhysicalCmd);
    }


    /**
     * 产品卡管理-创建产品券
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ProductCardCmd $ProductCardCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function createVirtual (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ProductCardCmd $ProductCardCmd) {
        return self::getClass()->createVirtual($ProductCardCmd);
    }


    /**
     * 优惠券管理-撤回审批
     *
     * @support  int $audit_id 审核记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelAudit () {
        return self::getClass()->cancelAudit([
        ]);
    }

    /**
     * 获取产品卡列表(分页)
     *
     * @support  int $create_log_id 创建记录id [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @support  array $codes 兑换码 [ require false ]
     * @support  string $used_at_start 使用时间起 [ require false ]
     * @support  string $used_at_end 使用时间止 [ require false ]
     * @support  array $multi_status 状态 [ require false ]
     * @support  bool $with_template_info 包含卡面信息 [ require false ]
     * @support  string $mobile 手机号 [ require false ]
     * @support  string $created_at_start 创建时间起 [ require false ]
     * @support  string $created_at_end 创建时间止 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function codeList () {
        return self::getClass()->codeList([
        ]);
    }

    /**
     * 获取券码列表(所有)
     *
     * @support  int $create_log_id 创建记录id [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @support  array $codes 兑换码 [ require false ]
     * @support  string $used_at_start 使用时间起 [ require false ]
     * @support  string $used_at_end 使用时间止 [ require false ]
     * @support  array $multi_status 状态 [ require false ]
     * @support  bool $with_template_info 包含卡面信息 [ require false ]
     * @support  string $mobile 手机号 [ require false ]
     * @support  string $created_at_start 创建时间起 [ require false ]
     * @support  string $created_at_end 创建时间止 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function codeAll () {
        return self::getClass()->codeAll([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Marketing\ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Marketing\ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}