<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getEnumByParams(array $params)
 * @method preferentialChannelsByParams(array $params)
 * @method searchByParams(array $params)
 * @method searchStaffByIdsByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取enum
     *
     * @param  string $enum_name enum的名称 [ require true ]
     * @param  string $field_name field的名称 [ require true ]
     * @param  string $type 结果展示的方式tree/map/list [ require true ]
     * @param  string $prefix 枚举前缀 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getEnum (string $enum_name, string $field_name, string $type, string $prefix = '') {
        return self::getClass()->getEnum([
            "enum_name" => $enum_name,
            "field_name" => $field_name,
            "type" => $type,
            "prefix" => $prefix,
        ]);
    }

    /**
     * 券码用途列表
     *
     * @support  bool $withAuth 是否进行权限判断 [ require true ]
     * @support  string $type 返回数据类型array:一维数组，tree:二级树结构 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function preferentialChannels () {
        return self::getClass()->preferentialChannels([
        ]);
    }

    /**
     * 通过伙伴姓名或花名获得可能的工号
     *
     * @param  string $staff_name 伙伴姓名或花名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function search (string $staff_name) {
        return self::getClass()->search([
            "staff_name" => $staff_name,
        ]);
    }

    /**
     * 通过工号获取伙伴信息
     *
     * @param  array $staffIds 伙伴id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\ExtendStaff\Dto\OneSimpleStaffDto[]
     */
    public static function searchStaffByIds (array $staffIds) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchStaffByIds([
                            "staffIds" => $staffIds,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ExtendStaff\Dto\OneSimpleStaffDto[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Common\Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Common\Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}