<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method filterPhotographyActionUnavailableDataByParams(array $params)
 * @method detailByParams(array $params)
 * @method executeDownByParams(array $params)
 * @method executeUpByParams(array $params)
 * @method autoDownByParams(array $params)
 * @method getOneByParams(array $params)
 * @method emptyByParams(array $params)
 */
class SamplePools {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 样片池列表
     *
     * @support  string $brand 品牌 [ require false ]
     * @support  array $product_ids 产品ids [ require false ]
     * @support  int $product_id 产品id [ require false ]
     * @support  string $type 样片类型 [ require false ]
     * @support  array $types 样片类型 [ require false ]
     * @support  int $uper 上传人 [ require false ]
     * @support  int $tag 相关标签 [ require false ]
     * @support  array $tags 相关标签ids [ require false ]
     * @support  bool $tag_relation_is_or 标签关系是否是or，默认表示and [ require false ]
     * @support  int $expired_at 到期时间 [ require false ]
     * @support  string $status 样片状态 [ require false ]
     * @support  string $db 请求数据源 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 过滤摄影动作不可用数据
     *
     * @support  array $product_ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function filterPhotographyActionUnavailableData () {
        return self::getClass()->filterPhotographyActionUnavailableData([
        ]);
    }

    /**
     * 样片池详情
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 下架样片
     *
     * @support  int $id 样片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function executeDown () {
        return self::getClass()->executeDown([
        ]);
    }

    /**
     * 重新上架样片
     *
     * @support  int $id 样片id [ require true ]
     * @support  array $tags 相关标签 [ require false ]
     * @support  string $expired_at 到期时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function executeUp () {
        return self::getClass()->executeUp([
        ]);
    }

    /**
     * 每天0点0分1秒执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoDown () {
        return self::getClass()->autoDown();
    }

    /**
     * 简单查询,检测一下带sql的极限性能
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOne () {
        return self::getClass()->getOne();
    }

    /**
     * 简单查询,检测一下带sql的极限性能
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function empty () {
        return self::getClass()->empty();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\SamplePools');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\SamplePools');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}