<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchPagesByParams(array|\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordSearchCmd $params)
 * @method detailByParams(array $params)
 * @method createOrEditByParams(array|\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordAddCmd $params)
 * @method cancelAuditByParams(array $params)
 */
class ActivitiesRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 活动备案-列表(分页)
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordSearchCmd $activitiesRecordSearchCmd
     * @throws  \Exception
     * @return  array
     */
    public static function searchPages (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordSearchCmd $activitiesRecordSearchCmd) {
        return self::getClass()->searchPages($activitiesRecordSearchCmd);
    }


    /**
     * 活动备案-详情
     *
     * @support  int $activityRecordId 活动备案id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 活动备案-创建(修改)活动备案并发起审批
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordAddCmd $activitiesRecordAddCmd
     * @throws  \Exception
     * @return  array
     */
    public static function createOrEdit (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordAddCmd $activitiesRecordAddCmd) {
        return self::getClass()->createOrEdit($activitiesRecordAddCmd);
    }


    /**
     * 活动备案-撤回审批
     *
     * @support  int $activityRecordId 活动备案id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelAudit () {
        return self::getClass()->cancelAudit([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Marketing\ActivitiesRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Marketing\ActivitiesRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}