<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchByParams(array $params)
 * @method searchStaffByIdsByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过伙伴姓名或花名获得可能的工号
     *
     * @param  string $staff_name 伙伴姓名或花名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function search (string $staff_name) {
        return self::getClass()->search([
            "staff_name" => $staff_name,
        ]);
    }

    /**
     * 通过工号获取伙伴信息
     *
     * @param  array $staffIds 伙伴id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\ExtendStaff\Dto\OneSimpleStaffDto[]
     */
    public static function searchStaffByIds (array $staffIds) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchStaffByIds([
                            "staffIds" => $staffIds,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\ExtendStaff\Dto\OneSimpleStaffDto[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Extend\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Extend\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}