<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLogsByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\Marketing\Cmd\PreferentialRecordCmd $params)
 * @method cancelAuditByParams(array $params)
 * @method codeListByParams(array $params)
 * @method codeAllByParams(array $params)
 */
class PreferentialCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 优惠券管理-优惠券创建记录查询
     *
     * @support  array $ids 批次ids [ require false ]
     * @support  array $channel 渠道号,未审批记录不查询此项 [ require false ]
     * @support  string $type 模板类型 [ require false ]
     * @support  string $status 审批状态 [ require true ]
     * @support  int $create_by 创建人 [ require false ]
     * @support  string $apply_in 应用于(蓝标/大师等) [ require false ]
     * @support  bool $with_template_info 包含模板信息 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLogs () {
        return self::getClass()->getLogs([
        ]);
    }

    /**
     * 优惠券管理-详情
     *
     * @support  int $audit_id 申请记录id [ require false ]
     * @support  int $create_log_id 创券记录id [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 优惠券管理-申请制券
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\Marketing\Cmd\PreferentialRecordCmd $preferentialRecordCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (\Mainto\Bridge\Structs\HimoProduct\Admin\Marketing\Cmd\PreferentialRecordCmd $preferentialRecordCmd) {
        return self::getClass()->create($preferentialRecordCmd);
    }


    /**
     * 优惠券管理-撤回审批
     *
     * @support  int $audit_id 审核记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelAudit () {
        return self::getClass()->cancelAudit([
        ]);
    }

    /**
     * 获取券码列表(分页)
     *
     * @support  int $create_log_id 创建记录id [ require false ]
     * @support  string $type 优惠券类型 [ require false ]
     * @support  string $apply_in 使用模块 [ require false ]
     * @support  string $used_at_start 使用时间起 [ require false ]
     * @support  string $used_at_end 使用时间止 [ require false ]
     * @support  string $mobile 手机号 [ require false ]
     * @support  int $user_id 用户id [ require false ]
     * @support  string $created_at_start 生成时间起 [ require false ]
     * @support  string $created_at_end 生成时间止 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $code 兑换码 [ require false ]
     * @support  bool $with_template_info 包含卡面信息 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function codeList () {
        return self::getClass()->codeList([
        ]);
    }

    /**
     * 获取券码列表(所有)
     *
     * @support  int $create_log_id 创建记录id [ require false ]
     * @support  array $multi_status 状态列表 [ require false ]
     * @support  string $apply_in 使用模块 [ require false ]
     * @support  string $used_at_start 使用时间起 [ require false ]
     * @support  string $used_at_end 使用时间止 [ require false ]
     * @support  string $type 优惠券类型 [ require false ]
     * @support  string $mobile 手机号 [ require false ]
     * @support  int $user_id 用户id [ require false ]
     * @support  string $created_at_start 生成时间起 [ require false ]
     * @support  string $created_at_end 生成时间止 [ require false ]
     * @support  array $codes 兑换码 [ require false ]
     * @support  bool $with_template_info 包含卡面信息 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function codeAll () {
        return self::getClass()->codeAll([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Marketing\PreferentialCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Marketing\PreferentialCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}