<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method editByParams(array $params)
 * @method listByParams(array $params)
 */
class Welfare {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加权益
     *
     * @support  string $welfare_name 权益名称 [ require false ]
     * @support  array $member_level 所属等级 [ require false ]
     * @support  int $sort 排序 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑权益
     *
     * @support  int $welfare_id 规则id [ require true ]
     * @support  string $welfare_name 权益名称 [ require false ]
     * @support  array $member_level 所属等级 [ require false ]
     * @support  int $sort 排序 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit () {
        return self::getClass()->edit([
        ]);
    }

    /**
     * 列表权益
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Welfare');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Welfare');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}