<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLogsByParams(array $params)
 * @method detailByParams(array $params)
 * @method createPhysicalByParams(array $params)
 * @method createVirtualByParams(array|\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\GiftCardCmd $params)
 * @method cancelAuditByParams(array $params)
 * @method codeListByParams(array $params)
 * @method codeAllByParams(array $params)
 */
class GiftCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 礼品卡创建记录查询
     *
     * @support  array $ids 记录ids [ require false ]
     * @support  int $create_by 创建人 [ require false ]
     * @support  string $status 审批状态 [ require true ]
     * @support  string $created_at_end 创建时间止 [ require false ]
     * @support  string $created_at_start 创建时间起 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLogs () {
        return self::getClass()->getLogs([
        ]);
    }

    /**
     * 礼品卡管理-详情
     *
     * @support  int $audit_id 申请记录id [ require false ]
     * @support  int $create_log_id 创券记录id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 礼品卡管理-创建实体卡
     *
     * @support  string $title 记录标题 [ require false ]
     * @support  int $cover_id 礼品卡封面 [ require true ]
     * @support  float $money 礼品卡面值 [ require true ]
     * @support  float $pay_money 实付金额 [ require false ]
     * @support  int $count 生成数量 [ require true ]
     * @support  array $extend 扩展信息-原因等数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPhysical () {
        return self::getClass()->createPhysical([
        ]);
    }

    /**
     * 礼品卡管理-申请礼品券
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\GiftCardCmd $giftCardCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function createVirtual (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\GiftCardCmd $giftCardCmd) {
        return self::getClass()->createVirtual($giftCardCmd);
    }


    /**
     * 优惠券管理-撤回审批
     *
     * @support  int $audit_id 审核记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelAudit () {
        return self::getClass()->cancelAudit([
        ]);
    }

    /**
     * 获取券码列表(分页)
     *
     * @support  int $id 礼品卡id [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $user_id 用户id [ require false ]
     * @support  string $code 礼品码 [ require false ]
     * @support  bool $with_cover_info 是否包含卡面信息 [ require false ]
     * @support  int $create_log_id 生成记录id [ require false ]
     * @support  string $created_at_start 生成时间起 [ require false ]
     * @support  string $created_at_end 生成时间止 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function codeList () {
        return self::getClass()->codeList([
        ]);
    }

    /**
     * 获取礼品卡列表(全部)
     *
     * @support  int $id 礼品卡编号 [ require false ]
     * @support  array $status 状态 [ require false ]
     * @support  string $code 礼品码 [ require false ]
     * @support  int $create_log_id 生成记录id [ require false ]
     * @support  string $created_at_start 生成时间起 [ require false ]
     * @support  string $created_at_end 生成时间止 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function codeAll () {
        return self::getClass()->codeAll([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Marketing\GiftCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Marketing\GiftCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}