<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createAppealByParams(array $params)
 * @method getAppealByParams(array $params)
 * @method getAppealByPageByParams(array $params)
 * @method appealDetailByParams(array $params)
 * @method auditAppealByParams(array $params)
 * @method modifyAppealByParams(array $params)
 * @method rejectModifyAppealByParams(array $params)
 * @method modifyProblemTagAppealByParams(array $params)
 * @method getProblemTagLikesByParams(array $params)
 * @method likeProblemTagByParams(array $params)
 * @method dislikeProblemTagByParams(array $params)
 * @method problemTagAppealDetailByParams(array $params)
 */
class Appeal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发起申诉
     *
     * @support  string $service_type 业务类型 [ require false ]
     * @support  string $service_id 业务唯一id,例如订单id [ require true ]
     * @support  array $service_content 业务内容 [ require true ]
     * @support  array $appeal_content 申诉内容 [ require true ]
     * @support  string $note 申诉备注 [ require false ]
     * @support  string $remark 问题标签申述备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAppeal () {
        return self::getClass()->createAppeal([
        ]);
    }

    /**
     * 获取申诉
     *
     * @support  string $service_type 业务类型 [ require false ]
     * @support  string $appeal_status 申诉状态 [ require false ]
     * @support  array $input_staff_ids 申请人ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppeal () {
        return self::getClass()->getAppeal([
        ]);
    }

    /**
     * 获取申诉分页
     *
     * @support  string $service_type 业务类型 [ require false ]
     * @support  string $appeal_status 申诉状态 [ require false ]
     * @support  array $input_staff_ids 申请人ids [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppealByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getAppealByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取申诉详情
     *
     * @param  int $id 申诉id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appealDetail (int $id) {
        return self::getClass()->appealDetail([
            "id" => $id,
        ]);
    }

    /**
     * 申诉审核
     *
     * @param  int $id 申诉id [ require true ]
     * @param  string $audit_status 审核结果 [ require true ]
     * @support  string $remark 问题标签申述备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function auditAppeal (int $id, string $audit_status) {
        return self::getClass()->auditAppeal([
            "id" => $id,
            "audit_status" => $audit_status,
        ]);
    }

    /**
     * 修改评分
     *
     * @support  int $appeal_id 申诉id [ require true ]
     * @support  string $pool_name 池名称 [ require true ]
     * @support  string $record_id 评价记录id [ require true ]
     * @support  array $modify_info 修改的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyAppeal () {
        return self::getClass()->modifyAppeal([
        ]);
    }

    /**
     * 拒绝修改评分
     *
     * @param  int $id 申诉id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function rejectModifyAppeal (int $id) {
        return self::getClass()->rejectModifyAppeal([
            "id" => $id,
        ]);
    }

    /**
     * 修改问题标签
     *
     * @support  int $appeal_id 申诉id [ require true ]
     * @support  string $appeal_status 申诉状态 [ require true ]
     * @support  string $remark 问题申诉备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyProblemTagAppeal () {
        return self::getClass()->modifyProblemTagAppeal([
        ]);
    }

    /**
     * 获取当前用户点赞的标签
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProblemTagLikes () {
        return self::getClass()->getProblemTagLikes([
        ]);
    }

    /**
     * 点赞问题标签
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @support  string $order_no 订单号 [ require true ]
     * @support  int $problem_tag_id 问题标签id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function likeProblemTag () {
        return self::getClass()->likeProblemTag([
        ]);
    }

    /**
     * 取消点赞问题标签
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @support  int $problem_tag_id 问题标签id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dislikeProblemTag () {
        return self::getClass()->dislikeProblemTag([
        ]);
    }

    /**
     * 获取问题标签申诉详情
     *
     * @support  string $service_id 业务唯一id,例如订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function problemTagAppealDetail () {
        return self::getClass()->problemTagAppealDetail([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Appeal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Appeal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}