<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPaymentRequestByParams(array $params)
 * @method getPaymentRequestDetailByParams(array $params)
 * @method getPaymentRequestListByParams(array $params)
 * @method resubmitPaymentRequestByParams(array $params)
 * @method paymentFailByParams(array $params)
 * @method getPaymentResultByParams(array $params)
 * @method submitPaymentByParams(array $params)
 * @method updatePaymentRequestByParams(array $params)
 * @method getPaymentRequestByParams(array $params)
 */
class PaymentOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建支付请求
     *
     * @support  int $fromId 付款流水号 [ require true ]
     * @support  string $reportDate 单据日期 require false
     * @support  string $latestPaymentDate 最晚付款时间 require false
     * @support  string $fromType 来源类型 require false
     * @support  string $fromCode 来源单据号 [ require true ]
     * @support  string $payName 付款组织 require false
     * @support  float $money 申请金额 [ require true ]
     * @support  string $payeeName 收款人 require false
     * @support  string $payeeAccount 收款账号 require false
     * @support  string $bankBranch 支行 require false
     * @support  string $bankNumber 联行号 require false
     * @support  string $reportType 付款类型 require false
     * @support  string $payType 付款方式 require false
     * @support  string $paymentPurpose 付款用途 require false
     * @support  string $proposer 申请人 [ require true ]
     * @support  string $departmentName 申请部门 [ require true ]
     * @support  string $bankName 申请部门 require false
     * @support  string $objectName 申请部门 require false
     * @throws  \Exception
     * @return  int
     */
    public static function createPaymentRequest () {
        return self::getClass()->createPaymentRequest();
    }

    /**
     * 获取支付请求详情
     *
     * @param  int $id 主键ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaymentRequestDetail (int $id) {
        return self::getClass()->getPaymentRequestDetail([
            "id" => $id,
        ]);
    }

    /**
     * 获取支付请求列表
     *
     * @support  string $fromCode 来源单号 require false
     * @support  string $proposer 申请人 require false
     * @support  string $status 状态 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页条数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getPaymentRequestList () {
        return self::getClass()->getPaymentRequestList();
    }

    /**
     * 重新付款
     *
     * @param  int $id 主键ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function resubmitPaymentRequest (int $id) {
        return self::getClass()->resubmitPaymentRequest([
            "id" => $id,
        ]);
    }

    /**
     * 付款失败
     *
     * @param  int $id 主键ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function paymentFail (int $id) {
        return self::getClass()->paymentFail([
            "id" => $id,
        ]);
    }

    /**
     * 获取结果
     *
     * @param  int $id 主键ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getPaymentResult (int $id) {
        return self::getClass()->getPaymentResult([
            "id" => $id,
        ]);
    }

    /**
     * 提交付款
     *
     * @param  int $id 主键ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submitPayment (int $id) {
        return self::getClass()->submitPayment([
            "id" => $id,
        ]);
    }

    /**
     * 更新支付请求
     *
     * @support  int $id 主键ID [ require true ]
     * @support  int $status 状态 [ require true ]
     * @support  string $paymentDate 付款时间 [ require true ]
     * @support  float $payAmount 实付金额 [ require true ]
     * @support  int $operator 打款操作人工号 [ require true ]
     * @support  string $serialNumber 资管流水号 require false
     * @support  string $paymentAccount 实付账号 [ require true ]
     * @support  string $errType 错误类型 require false
     * @support  string $failCause 失败原因 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function updatePaymentRequest () {
        return self::getClass()->updatePaymentRequest();
    }

    /**
     * 获取支付请求
     *
     * @param  string $fromCode 来源单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaymentRequest (string $fromCode) {
        return self::getClass()->getPaymentRequest([
            "fromCode" => $fromCode,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PaymentOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PaymentOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}