<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method detailByParams(array $params)
 */
class ProductCardTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @support  string $name 优惠名称 [ require true ]
     * @support  array $limit 优惠限制 [ require true ]
     * @support  string $apply_in 应用于 require false
     * @support  array $extend 拓展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新
     *
     * @support  int $id 模板id [ require true ]
     * @support  string $name 优惠名称 require false
     * @support  array $limit 优惠限制 require false
     * @support  bool $special 限时优惠 require false
     * @support  bool $action_scope 升级体验 require false
     * @support  array $extend 拓展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取产品卡模板列表(分页)
     *
     * @support  string $name 优惠名称 require false
     * @support  string $type 类型 require false
     * @support  int $page 分页 require false
     * @support  string $apply_in 应用于 require false
     * @support  int $page_size 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取产品卡模板列表(所有)
     *
     * @support  string $name 优惠名称 require false
     * @support  string $apply_in 应用于 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 产品卡模板详情
     *
     * @support  int $id 产品卡模板id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductCardTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductCardTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}