<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method samplePhotoExpireNoticeByParams(array $params)
 * @method reservationLogByParams(array $params)
 * @method reservationChangeByParams(array $params)
 * @method refreshSessionByParams(array $params)
 * @method returnGiftCardByParams(array $params)
 * @method effectCompareByParams(array $params)
 * @method pushPregnantKfMsgByParams(array $params)
 * @method sendDingDingNotifyByParams(array $params)
 * @method sendAppointmentNoticePushByParams(array $params)
 * @method autoDealRefundByParams(array $params)
 * @method autoCheckRefundHasInvoiceByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天10点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function samplePhotoExpireNotice () {
        return self::getClass()->samplePhotoExpireNotice();
    }

    /**
     * 每天1点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservationLog () {
        return self::getClass()->reservationLog();
    }

    /**
     * 每天11点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservationChange () {
        return self::getClass()->reservationChange();
    }

    /**
     * 每月的1号15号2点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshSession () {
        return self::getClass()->refreshSession();
    }

    /**
     * 未接受礼品卡退还
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnGiftCard () {
        return self::getClass()->returnGiftCard();
    }

    /**
     * 每天9点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function effectCompare () {
        return self::getClass()->effectCompare();
    }

    /**
     * 每天18点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushPregnantKfMsg () {
        return self::getClass()->pushPregnantKfMsg();
    }

    /**
     * 每天10点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendDingDingNotify () {
        return self::getClass()->sendDingDingNotify();
    }

    /**
     * 发送预约提醒消息
     *
     * @support  string $title 标题 [ require true ]
     * @support  array $userInfo 用户信息 [ require true ]
     * @support  array $storeInfo 门店信息 [ require true ]
     * @support  array $orderInfo 订单信息 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendAppointmentNoticePush () {
        return self::getClass()->sendAppointmentNoticePush();
    }

    /**
     * 每月2号处理月末月初的退款
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoDealRefund () {
        return self::getClass()->autoDealRefund();
    }

    /**
     * 检查退款中是否存在冲红成功的
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoCheckRefundHasInvoice () {
        return self::getClass()->autoCheckRefundHasInvoice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}