<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateMobileByParams(array $params)
 * @method getUserByPhoneByParams(array $params)
 * @method getUserByIdByParams(array $params)
 * @method detailByParams(array $params)
 * @method flowByParams(array $params)
 * @method listByParams(array $params)
 * @method sendBirthCouponByParams(array $params)
 * @method bindActiveVipByParams(array $params)
 * @method createUserFlowByParams(array $params)
 * @method fixScoreByParams(array $params)
 * @method fixCouponByParams(array $params)
 * @method getUserWxCardInfoByParams(array $params)
 * @method logoutMobileByParams(array $params)
 * @method logoutAndChangeMobileByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 增加一条用户信息
     *
     * @support  string $phone 手机号 [ require true ]
     * @support  string $sex 用户性别(male男|female女) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改用户手机
     *
     * @support  string $new_phone 新手机号 require false
     * @support  string $old_phone 旧手机号 require false
     * @support  string $code 验证码 require false
     * @support  string $certificate 用户沟通凭证 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateMobile () {
        return self::getClass()->updateMobile();
    }

    /**
     * 注意：隐含了创建...没有用户就自动注册一个
     * TODO 该接口被其它场景用到后，重构支持选择是否加载优惠信息
     *
     * @support  string $phone 用户手机号 [ require true ]
     * @support  string $apply_in 用户手机号 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserByPhone () {
        return self::getClass()->getUserByPhone();
    }

    /**
     * 注意：隐含了创建...没有用户就自动注册一个
     * TODO 该接口被其它场景用到后，重构支持选择是否加载优惠信息
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserById (int $user_id) {
        return self::getClass()->getUserById([
            "user_id" => $user_id,
        ]);
    }

    /**
     * TODO 该接口被其它场景用到后，重构支持选择是否加载优惠信息
     *
     * @param  int $user_id 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $user_id) {
        return self::getClass()->detail([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 获取用户流水
     *
     * @support  int $id 用户id [ require true ]
     * @support  int $page 页码 require false
     * @support  int $page_size 条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function flow () {
        return self::getClass()->flow();
    }

    /**
     * 获取用户列表
     *
     * @support  string $nickname 用户昵称 require false
     * @support  string $level 会员等级 require false
     * @support  string $times 消费次数 require false
     * @support  int $interval 消费间隔 require false
     * @support  string $create_time_start 注册时间-开始 require false
     * @support  string $create_time_end 注册时间-结束 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 发生日礼遇券
     *
     * @support  int $phone 用户手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendBirthCoupon () {
        return self::getClass()->sendBirthCoupon();
    }

    /**
     * bindActiveVip
     *
     * @param  int $user_id 用户id [ require true ]
     * @param  string $action 修复类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindActiveVip (int $user_id, string $action) {
        return self::getClass()->bindActiveVip([
            "user_id" => $user_id,
            "action" => $action,
        ]);
    }

    /**
     * createUserFlow
     *
     * @support  array $order_nos 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createUserFlow () {
        return self::getClass()->createUserFlow();
    }

    /**
     * 用户积分修正
     *
     * @support  int $score 用户增加/减少积分 [ require true ]
     * @support  int $user_id 用户id [ require true ]
     * @support  string $scene 公众号 [ require true ]
     * @support  string $card_id 卡id [ require true ]
     * @support  int $user_consume_num 用户消费次数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixScore () {
        return self::getClass()->fixScore();
    }

    /**
     * 用户优惠券修正
     *
     * @param  array $user_ids 用户ids [ require true ]
     * @param  string $type 优惠券发放类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixCoupon (array $user_ids, string $type) {
        return self::getClass()->fixCoupon([
            "user_ids" => $user_ids,
            "type" => $type,
        ]);
    }

    /**
     * 获取用户会员信息
     *
     * @param  string $scene 公众号 [ require true ]
     * @param  string $card_id 卡id [ require true ]
     * @param  string $code 卡号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserWxCardInfo (string $scene, string $code, string $card_id) {
        return self::getClass()->getUserWxCardInfo([
            "scene" => $scene,
            "code" => $code,
            "card_id" => $card_id,
        ]);
    }

    /**
     * 注销用户手机
     *
     * @support  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function logoutMobile () {
        return self::getClass()->logoutMobile();
    }

    /**
     * 注销并修改手机号
     *
     * @support  string $new_phone 新手机号 require false
     * @support  string $old_phone 旧手机号 require false
     * @support  string $code 验证码 require false
     * @support  string $certificate 用户沟通凭证 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function logoutAndChangeMobile () {
        return self::getClass()->logoutAndChangeMobile();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}