<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchOperateCouponByParams(array $params)
 */
class Dispatch {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量操作券码
     *
     * @support  string $stop_time 新的过期时间Y-m-d H:i:s require false
     * @support  array $arr 券码字符串数组,[&#039;abc&#039;,&#039;cba&#039;] require false
     * @support  array $ids 券码id数组,[1,2] require false
     * @support  string $coupon_type 券码类型，gift_card/preferential/interior_preferential/product_card [ require true ]
     * @support  string $operation 操作类型，delay/abolish [ require true ]
     * @support  string $reason 作废/延期理由 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchOperateCoupon () {
        return self::getClass()->batchOperateCoupon();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Dispatch');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Dispatch');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}