<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchByIdByParams(array $params)
 * @method receiveCouponByParams(array $params)
 * @method getJssdkByParams(array $params)
 * @method receiveCouponByAuthByParams(array $params)
 */
class ActivityPage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 单个活动查询[用户端]
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchById (string $_id) {
        return self::getClass()->searchById([
            "_id" => $_id,
        ]);
    }

    /**
     * 用户领券
     *
     * @param  string $_id 活动id [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveCoupon (string $_id, string $phone, string $code = '') {
        return self::getClass()->receiveCoupon([
            "_id" => $_id,
            "phone" => $phone,
            "code" => $code,
        ]);
    }

    /**
     * 获取微信签名jssdk配置
     *
     * @param  string $_id 活动id [ require true ]
     * @param  string $url 活动链接 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getJssdk (string $_id, string $url) {
        return self::getClass()->getJssdk([
            "_id" => $_id,
            "url" => $url,
        ]);
    }

    /**
     * 用户领券.鉴权
     *
     * @param  string $_id 活动id [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveCouponByAuth (string $_id, string $phone) {
        return self::getClass()->receiveCouponByAuth([
            "_id" => $_id,
            "phone" => $phone,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\ActivityPage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\ActivityPage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}