<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method staffByParams(array $params)
 * @method allByParams(array $params)
 * @method allNowByParams(array $params)
 * @method newCurrentFinanceFluentByParams(array $params)
 * @method getSyncMarketConfigByParams(array $params)
 * @method getSyncMarketTurnoverInfosByParams(array $params)
 */
class PerformanceCollect {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 个人绩效统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $stop_time 查询的结束时间 [ require true ]
     * @support  int $staff_id 个人id [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staff () {
        return self::getClass()->staff();
    }

    /**
     * 总体绩效统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $stop_time 查询的结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 总体绩效统计(实时查询)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function allNow () {
        return self::getClass()->allNow();
    }

    /**
     * 新版财务流水，往日取自大数据，今日取自实时计算
     *
     * @support  string $start_time 查询的开始时间 require false
     * @support  string $stop_time 查询的结束时间 require false
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function newCurrentFinanceFluent () {
        return self::getClass()->newCurrentFinanceFluent();
    }

    /**
     * 获取接驳门店配置
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSyncMarketConfig () {
        return self::getClass()->getSyncMarketConfig();
    }

    /**
     * 根据上报商场流水号获取流水信息
     *
     * @param  string $orderId 商场流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSyncMarketTurnoverInfos (string $orderId) {
        return self::getClass()->getSyncMarketTurnoverInfos([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PerformanceCollect');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PerformanceCollect');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}