<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookCloseOrderByParams(array $params)
 * @method firstClickByParams(array $params)
 * @method icbcPhotoByParams(array $params)
 * @method sendAppOrderShareCouponByParams(array $params)
 * @method afterRefundByParams(array $params)
 * @method orderCompleteByParams(array $params)
 * @method sendKfMessageByParams(array $params)
 * @method sendRetailKfMessageByParams(array $params)
 * @method sendKidsMessageByParams(array $params)
 * @method sendMantuXxzMessageByParams(array $params)
 * @method paySuccessSendNoticeByParams(array $params)
 * @method yuanyangKfMsgByParams(array $params)
 * @method photoTemplatesByParams(array $params)
 * @method sendNormalNotifyByParams(array $params)
 * @method babyInfoByParams(array $params)
 * @method checkOccByParams(array $params)
 * @method checkOccByStoreIdsByParams(array $params)
 * @method gestationalWeekByParams(array $params)
 * @method sendMessageByParams(array $params)
 * @method sendKfStoreQrMessageByParams(array $params)
 * @method sendChristmasKfMessageByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 关闭订单
     *
     * @param  array $orderObject 订单数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloseOrder (array $orderObject) {
        return self::getClass()->hookCloseOrder([
            "orderObject" => $orderObject,
        ]);
    }

    /**
     * 第一次进入支付链接(仅限拍摄订单)
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function firstClick (string $orderNum) {
        return self::getClass()->firstClick([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * icbc真我卡获取云端原片地址
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function icbcPhoto () {
        return self::getClass()->icbcPhoto();
    }

    /**
     * app下载成片分享赠送加印券
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendAppOrderShareCoupon (int $user_id) {
        return self::getClass()->sendAppOrderShareCoupon([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 退款完成推送通知
     *
     * @support  int $refundId refund id [ require true ]
     * @support  float $oldRefundMoney 需要扣除的退款金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function afterRefund () {
        return self::getClass()->afterRefund();
    }

    /**
     * 订单完成推送通知
     *
     * @support  int $orderId 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderComplete () {
        return self::getClass()->orderComplete();
    }

    /**
     * 婚礼照推送
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKfMessage () {
        return self::getClass()->sendKfMessage();
    }

    /**
     * 零售客服消息
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendRetailKfMessage () {
        return self::getClass()->sendRetailKfMessage();
    }

    /**
     * 小幸运kids营销推送
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKidsMessage () {
        return self::getClass()->sendKidsMessage();
    }

    /**
     * 缦图形象照客服消息
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendMantuXxzMessage () {
        return self::getClass()->sendMantuXxzMessage();
    }

    /**
     * 支付成功推送
     *
     * @support  array $wxData 微信发送参数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paySuccessSendNotice () {
        return self::getClass()->paySuccessSendNotice();
    }

    /**
     * 鸳鸯照推送
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function yuanyangKfMsg () {
        return self::getClass()->yuanyangKfMsg();
    }

    /**
     * 获取照片模板
     *
     * @param  array $product_ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoTemplates (array $product_ids) {
        return self::getClass()->photoTemplates([
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 看片通知
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $type 类型 require false
     * @support  bool $can_store_look_photo 是否可以预约门店看片 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendNormalNotify () {
        return self::getClass()->sendNormalNotify();
    }

    /**
     * 更新订单婴儿信息
     *
     * @support  string $_id _id [ require true ]
     * @support  string $baby_name 宝贝名 require false
     * @support  string $baby_birth 宝贝生日 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function babyInfo () {
        return self::getClass()->babyInfo();
    }

    /**
     * 检查全家福每日的占点
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  string $start_at 开始时间 [ require true ]
     * @support  string $end_at 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOcc () {
        return self::getClass()->checkOcc();
    }

    /**
     * 检查全家福每日的占点
     *
     * @support  array $store_ids 门店ids [ require true ]
     * @support  string $date 时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOccByStoreIds () {
        return self::getClass()->checkOccByStoreIds();
    }

    /**
     * 查询记录的孕周信息
     *
     * @support  string $start_at 开始时间 require false
     * @support  string $end_at 结束时间 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function gestationalWeek () {
        return self::getClass()->gestationalWeek();
    }

    /**
     * 推送客服消息
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  array $message_text 文字消息 require false
     * @support  array $image_media 图片消息 require false
     * @support  array $article_media 图文消息 require false
     * @support  array $rule 消息规则 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendMessage () {
        return self::getClass()->sendMessage();
    }

    /**
     * 推送客服消息
     *
     * @param  int $user_id 用户id [ require true ]
     * @param  string $media_id 图片media_id信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKfStoreQrMessage (int $user_id, string $media_id) {
        return self::getClass()->sendKfStoreQrMessage([
            "user_id" => $user_id,
            "media_id" => $media_id,
        ]);
    }

    /**
     * 给圣诞期间下单但不是圣诞照的用户发送优惠券
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendChristmasKfMessage (int $user_id) {
        return self::getClass()->sendChristmasKfMessage([
            "user_id" => $user_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}