<?php
namespace Mainto\Bridge\Invokes\HimoProduct\BuyerShow;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method buyerShowListByParams(array|\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\BuyerShowListCmd $params)
 * @method createBuyerShowByParams(array|\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\CreateBuyerShowCmd $params)
 * @method updateBuyerShowByParams(array|\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\UpdateBuyerShowCmd $params)
 * @method buyerShowOrderInfoByParams(array $params)
 * @method buyerShowDetailByParams(array $params)
 * @method inviteStaffListByParams(array $params)
 * @method sendInviteByParams(array $params)
 * @method auditPassByParams(array $params)
 * @method auditRejectByParams(array $params)
 * @method setStarByParams(array $params)
 * @method cancelStarByParams(array $params)
 * @method setAfterSaleByParams(array $params)
 */
class BuyerShow {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 买家秀列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\BuyerShowListCmd $buyerShowListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\BuyerShowListDTO
     */
    public static function buyerShowList (\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\BuyerShowListCmd $buyerShowListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->buyerShowList($buyerShowListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\BuyerShowListDTO"
        );
    }


    /**
     * 创建买家秀
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\CreateBuyerShowCmd $createBuyerShowCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createBuyerShow (\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\CreateBuyerShowCmd $createBuyerShowCmd) {
        return self::getClass()->createBuyerShow($createBuyerShowCmd);
    }


    /**
     * 更新买家秀
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\UpdateBuyerShowCmd $updateBuyerShowCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateBuyerShow (\Mainto\Bridge\Structs\HimoProduct\BuyerShow\Cmd\UpdateBuyerShowCmd $updateBuyerShowCmd) {
        return self::getClass()->updateBuyerShow($updateBuyerShowCmd);
    }


    /**
     * 订单卖家秀信息
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\BuyerShowOrderDTO
     */
    public static function buyerShowOrderInfo (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->buyerShowOrderInfo([
                            "orderNum" => $orderNum,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\BuyerShowOrderDTO"
        );
    }

    /**
     * 买家秀详情
     *
     * @param  int $shareOrderId 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\InviteStaffDTO
     */
    public static function buyerShowDetail (int $shareOrderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->buyerShowDetail([
                            "shareOrderId" => $shareOrderId,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\InviteStaffDTO"
        );
    }

    /**
     * 发起人列表
     *
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\InviteStaffDTO[]
     */
    public static function inviteStaffList (string $brand) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->inviteStaffList([
                            "brand" => $brand,
                        ]),
            "\Mainto\Bridge\Structs\HimoProduct\BuyerShow\DTO\InviteStaffDTO[]"
        );
    }

    /**
     * 发送邀请
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendInvite (string $orderNum) {
        return self::getClass()->sendInvite([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 审核通过
     *
     * @param  int $shareOrderId 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function auditPass (int $shareOrderId) {
        return self::getClass()->auditPass([
            "shareOrderId" => $shareOrderId,
        ]);
    }

    /**
     * 审核拒绝
     *
     * @param  int $shareOrderId 买家秀ID [ require true ]
     * @param  string $reason 不通过理由 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function auditReject (int $shareOrderId, string $reason) {
        return self::getClass()->auditReject([
            "shareOrderId" => $shareOrderId,
            "reason" => $reason,
        ]);
    }

    /**
     * 设为精选|上架
     *
     * @param  int $shareOrderId 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setStar (int $shareOrderId) {
        return self::getClass()->setStar([
            "shareOrderId" => $shareOrderId,
        ]);
    }

    /**
     * 转接售后
     *
     * @param  int $shareOrderId 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelStar (int $shareOrderId) {
        return self::getClass()->cancelStar([
            "shareOrderId" => $shareOrderId,
        ]);
    }

    /**
     * 转接售后
     *
     * @param  int $shareOrderId 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setAfterSale (int $shareOrderId) {
        return self::getClass()->setAfterSale([
            "shareOrderId" => $shareOrderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'BuyerShow\BuyerShow');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'BuyerShow\BuyerShow');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}