<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method setStarByParams(array $params)
 * @method cancelStarByParams(array $params)
 * @method setAfterSaleByParams(array $params)
 */
class BuyerShowOld {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 晒单列表
     *
     * @support  string $start_time 提交日期开始时间 [ require false ]
     * @support  string $end_time 提交日期结束时间 [ require false ]
     * @support  int $star_level 星级 [ require false ]
     * @support  string $order_num 订单号 [ require false ]
     * @support  string $phone 手机号查询 [ require false ]
     * @support  int $type 类型 [ require false ]
     * @support  string $keyword 关键词 [ require false ]
     * @support  array $product_ids 产品ids [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 设为精选
     *
     * @support  int $id 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStar () {
        return self::getClass()->setStar([
        ]);
    }

    /**
     * 取消精选
     *
     * @support  int $id 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelStar () {
        return self::getClass()->cancelStar([
        ]);
    }

    /**
     * 转接售后
     *
     * @support  int $id 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAfterSale () {
        return self::getClass()->setAfterSale([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\BuyerShowOld');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\BuyerShowOld');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}