<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTokenByParams(array $params)
 * @method getOnlineUserInfoByParams(array $params)
 * @method getCallUserInfoByParams(array $params)
 * @method getOnlineAccountListByParams(array $params)
 * @method getCallAccountListByParams(array $params)
 * @method getOnlineUserInfoForZhiChiByParams(array $params)
 * @method getCallUserInfoForZhiChiByParams(array $params)
 * @method getOnlineOrderListByParams(array $params)
 * @method getCallOrderListByParams(array $params)
 */
class Qiyu {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取token值
     *
     * @support  string $appid appId [ require true ]
     * @support  string $appsecret appSecret [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getToken () {
        return self::getClass()->getToken([
        ]);
    }

    /**
     * 获取用户信息-在线
     *
     * @support  string $userid openid [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOnlineUserInfo () {
        return self::getClass()->getOnlineUserInfo([
        ]);
    }

    /**
     * 获取用户信息-呼叫中心
     *
     * @support  string $userid 手机号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCallUserInfo () {
        return self::getClass()->getCallUserInfo([
        ]);
    }

    /**
     * 获取用户订单列表-在线
     *
     * @support  string $userid openid [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOnlineAccountList () {
        return self::getClass()->getOnlineAccountList([
        ]);
    }

    /**
     * 根据手机号获取用户订单列表
     *
     * @support  string $userid phone [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCallAccountList () {
        return self::getClass()->getCallAccountList([
        ]);
    }

    /**
     * 获取用户信息-在线
     *
     * @support  string $userid openid [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOnlineUserInfoForZhiChi () {
        return self::getClass()->getOnlineUserInfoForZhiChi([
        ]);
    }

    /**
     * 获取用户信息-呼叫中心
     *
     * @support  string $userid 手机号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCallUserInfoForZhiChi () {
        return self::getClass()->getCallUserInfoForZhiChi([
        ]);
    }

    /**
     * 获取用户订单列表-在线
     *
     * @support  string $userid openid [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOnlineOrderList () {
        return self::getClass()->getOnlineOrderList([
        ]);
    }

    /**
     * 根据手机号获取用户订单列表
     *
     * @support  string $userid phone [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCallOrderList () {
        return self::getClass()->getCallOrderList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Extend\Qiyu');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Extend\Qiyu');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}