<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\OrderCompensation\Dto\OrderCompensationDto $params)
 * @method detailByParams(array $params)
 * @method operationLogDetailByParams(array $params)
 * @method saveSatisfactionSurveyByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\OrderCompensation\Dto\SaveSatisfactionSurveyDto $params)
 * @method terminateProcessByParams(array|\Mainto\Bridge\Structs\HimoProduct\Admin\OrderCompensation\Dto\TerminateProcessDto $params)
 */
class OrderCompensation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建售后补偿订单
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\OrderCompensation\Dto\OrderCompensationDto $dto
     * @throws  \Exception
     * @return  array
     */
    public static function create (\Mainto\Bridge\Structs\HimoProduct\Admin\OrderCompensation\Dto\OrderCompensationDto $dto) {
        return self::getClass()->create($dto);
    }


    /**
     * 获取发起售后订单详情
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 获售后订单操作详情
     *
     * @support  int $afterSaleOrderId 售后订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function operationLogDetail () {
        return self::getClass()->operationLogDetail([
        ]);
    }

    /**
     * 保存售后评价消息
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\OrderCompensation\Dto\SaveSatisfactionSurveyDto $dto
     * @throws  \Exception
     * @return  array
     */
    public static function saveSatisfactionSurvey (\Mainto\Bridge\Structs\HimoProduct\Admin\OrderCompensation\Dto\SaveSatisfactionSurveyDto $dto) {
        return self::getClass()->saveSatisfactionSurvey($dto);
    }


    /**
     * 撤回售后赔偿订单申请
     *
     * @var  \Mainto\Bridge\Structs\HimoProduct\Admin\OrderCompensation\Dto\TerminateProcessDto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function terminateProcess (\Mainto\Bridge\Structs\HimoProduct\Admin\OrderCompensation\Dto\TerminateProcessDto $dto) {
        return self::getClass()->terminateProcess($dto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\OrderCompensation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\OrderCompensation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}