<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method stockProductListByParams(array $params)
 * @method allotByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 管理端-预消费卡库存列表查询
     *
     * @support  string $type 卡券类型gift_card/product_card [ require false ]
     * @support  int $operate_id cover_id/product_id [ require false ]
     * @support  int $store_id 门店id [ require true ]
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 一页显示条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 管理端-库存记录详情
     *
     * @param  int $id 库存记录id [ require true ]
     * @param  string $type 卡券类型gift_card/product_card [ require true ]
     * @param  int $page 页数 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockProductList (int $id, string $type, int $page = 1, int $page_size = 20) {
        return self::getClass()->stockProductList([
            "id" => $id,
            "type" => $type,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 管理端-预消费卡调拨
     *
     * @support  array $detail 调拨详情数据 [ require false ]
     * @support  int $stock_store_id 当前库存地的门店id [ require true ]
     * @support  string $type 卡类型,gift_card/product_card [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allot () {
        return self::getClass()->allot([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}