<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method authorizeByParams(array $params)
 * @method authorizeCheckByParams(array $params)
 * @method isvConsumeByParams(array $params)
 * @method getMeituanStoreListByParams(array $params)
 * @method getBatchRemainCountByParams(array $params)
 * @method startBookByParams(array $params)
 * @method afterPayByParams(array $params)
 * @method bookResultCallbackByParams(array $params)
 * @method bookResultNotifyByParams(array $params)
 * @method cancelBookByParams(array $params)
 * @method consumeStatusByParams(array $params)
 * @method platformConsumeByParams(array $params)
 * @method consumeCodeByParams(array $params)
 * @method prepareByParams(array $params)
 * @method checkConsumedByParams(array $params)
 * @method createPaymentByParams(array $params)
 * @method paymentCallbackByParams(array $params)
 * @method sendPreferentialByParams(array $params)
 * @method refundPreferentialByParams(array $params)
 * @method forceRefundPreferentialByParams(array $params)
 * @method usePreferentialByParams(array $params)
 * @method getSessionForBigDataByParams(array $params)
 * @method ugcNotifyByParams(array $params)
 * @method flushCacheByParams(array $params)
 */
class DaZhongDianPing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 授权
     *
     * @support  string $appKey 应用KEY [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function authorize () {
        return self::getClass()->authorize([
        ]);
    }

    /**
     * 授权回调
     *
     * @param  string $state 状态码 [ require true ]
     * @param  string $auth_code 授权码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function authorizeCheck (string $state, string $auth_code) {
        return self::getClass()->authorizeCheck([
            "state" => $state,
            "auth_code" => $auth_code,
        ]);
    }

    /**
     * 到店核销
     *
     * @param  string $order_num 海马体订单号 [ require true ]
     * @param  int $store_id 海马体门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function isvConsume (string $order_num, int $store_id) {
        return self::getClass()->isvConsume([
            "order_num" => $order_num,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 获取已授权店铺列表
     *
     * @param  string $storeType 门店类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMeituanStoreList (string $storeType) {
        return self::getClass()->getMeituanStoreList([
            "storeType" => $storeType,
        ]);
    }

    /**
     * 批量获取库存
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @support  string $app_shop_id 海马体门店id [ require false ]
     * @support  string $open_shop_uuid 美团点评门店id [ require false ]
     * @support  string $bookdate 预定时间，Y-m-d [ require true ]
     * @support  string $durations 服务时长 [ require false ]
     * @support  string $days 几天的库存 [ require true ]
     * @support  string $inventory_product_info 项目信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBatchRemainCount () {
        return self::getClass()->getBatchRemainCount([
        ]);
    }

    /**
     * 预定
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @support  string $app_shop_id 海马体门店id [ require false ]
     * @support  string $open_shop_uuid 美团点评门店id [ require false ]
     * @support  string $order_id 美团订单id [ require true ]
     * @support  string $app_product_id 海马体产品id [ require true ]
     * @support  int $product_id 美团产品id [ require false ]
     * @support  string $product_name 产品名称 [ require false ]
     * @support  string $begintime 服务开始时间，Y-m-d H:i:s [ require true ]
     * @support  int $duration 持续时长 [ require false ]
     * @support  string $endtime 服务结束时间，Y-m-d H:i:s [ require true ]
     * @support  string $products 预定商品信息 [ require false ]
     * @support  string $user_name 用户名 [ require false ]
     * @support  string $user_gender 性别 [ require false ]
     * @support  string $mobile 手机号 [ require true ]
     * @support  string $app_period_id 时段id [ require false ]
     * @support  int $user_age 用户年龄 [ require false ]
     * @support  string $identity_num 身份证 [ require false ]
     * @support  string $married 是否结婚1未婚2已婚 [ require false ]
     * @support  string $amount 订单原总价 [ require false ]
     * @support  string $order_shoppromo_details 订单优惠详情 [ require false ]
     * @support  int $quantity 预定数量 [ require true ]
     * @support  string $comment 备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startBook () {
        return self::getClass()->startBook([
        ]);
    }

    /**
     * 支付完成后续流程
     *
     * @param  int $order_id 海马体订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function afterPay (int $order_id) {
        return self::getClass()->afterPay([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 回调通知大众点评下单结果
     *
     * @support  string $meituan_order_id 美团订单id [ require true ]
     * @support  int $store_id 海马体门店id [ require true ]
     * @support  string $order_num 订单号 [ require true ]
     * @support  int $status 下单结果 [ require true ]
     * @support  string $open_shop_uuid 美团店铺ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bookResultCallback () {
        return self::getClass()->bookResultCallback([
        ]);
    }

    /**
     * 大众点评预定处理结果同步海马体
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $app_shop_id 海马体门店id [ require false ]
     * @support  string $open_shop_uuid 美团点评门店id [ require false ]
     * @support  string $order_id 美团订单id [ require true ]
     * @support  string $app_product_id 海马体产品id [ require true ]
     * @support  int $product_id 美团产品id [ require false ]
     * @support  string $product_name 产品名称 [ require false ]
     * @support  int $book_channel 预定渠道1三方2美大 [ require true ]
     * @support  int $book_status 预定结果2成功3失败 [ require true ]
     * @support  string $begintime 服务开始时间，Y-m-d H:i [ require true ]
     * @support  int $duration 持续时长 [ require false ]
     * @support  string $endtime 服务结束时间，Y-m-d H:i [ require true ]
     * @support  string $products 预定商品信息 [ require false ]
     * @support  string $user_name 用户名 [ require false ]
     * @support  string $user_gender 性别 [ require false ]
     * @support  string $mobile 手机号 [ require true ]
     * @support  string $app_period_id 时段id [ require false ]
     * @support  int $user_age 用户年龄 [ require false ]
     * @support  string $identity_num 身份证 [ require false ]
     * @support  string $married 是否结婚1未婚2已婚 [ require false ]
     * @support  string $amount 订单原总价 [ require false ]
     * @support  string $order_shoppromo_details 订单优惠详情 [ require false ]
     * @support  int $quantity 预定数量 [ require true ]
     * @support  string $comment 备注 [ require false ]
     * @support  string $biz_type biz_type [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bookResultNotify () {
        return self::getClass()->bookResultNotify([
        ]);
    }

    /**
     * 取消预定
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @support  string $app_shop_id 海马体门店id [ require false ]
     * @support  string $open_shop_uuid 美团点评门店id [ require false ]
     * @support  string $order_id 美团订单id [ require false ]
     * @support  int $cancel_type 取消类型 1=规则取消：用户正常规则下取消 2=非规则取消：除规则取消之外的其他取消，如用户通过开放平台客服强制取消 [ require true ]
     * @support  int $audit_channel 取消预定审核渠道1海马体2美团 [ require false ]
     * @support  string $reason 取消的原因 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelBook () {
        return self::getClass()->cancelBook([
        ]);
    }

    /**
     * 取消预定时的订单状态查询
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @support  string $order_id 美团订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function consumeStatus () {
        return self::getClass()->consumeStatus([
        ]);
    }

    /**
     * 核销状态同步
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require false ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @support  string $order_id 美团订单id [ require true ]
     * @support  int $verify_status 核销状态2核销成功 [ require true ]
     * @support  int $verify_channel 核销渠道 1=第三方平台核销 2=新美大平台核销 [ require true ]
     * @support  string $app_shop_id 海马体门店id [ require false ]
     * @support  string $open_shop_uuid 美团门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function platformConsume () {
        return self::getClass()->platformConsume([
        ]);
    }

    /**
     * 核销美团大众券
     *
     * @param  string $receipt_code 美团大众点评团购券 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function consumeCode (string $receipt_code, int $store_id) {
        return self::getClass()->consumeCode([
            "receipt_code" => $receipt_code,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 校验美团大众券信息
     *
     * @param  string $receipt_code 美团大众点评团购券 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function prepare (string $receipt_code, int $store_id) {
        return self::getClass()->prepare([
            "receipt_code" => $receipt_code,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 检查是否已核销
     *
     * @param  string $receipt_code 美团大众点评团购券 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkConsumed (string $receipt_code, int $store_id) {
        return self::getClass()->checkConsumed([
            "receipt_code" => $receipt_code,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 创建美团大众点评支付单
     *
     * @support  string $order_num 订单号或子订单号 [ require true ]
     * @support  float $pay_money 金额 [ require true ]
     * @support  int $operator_id 操作人 [ require false ]
     * @support  string $receipt_code 核销码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createPayment () {
        return self::getClass()->createPayment([
        ]);
    }

    /**
     * 支付回调
     *
     * @support  string $data 交易返回数据 [ require true ]
     * @support  string $sign 支付签名 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentCallback () {
        return self::getClass()->paymentCallback([
        ]);
    }

    /**
     * 团购发券
     *
     * @support  string $app_deal_id 第三方团单id,即产品卡template_id [ require true ]
     * @support  string $order_id 开放平台上的订单ID [ require true ]
     * @support  string $mobile_no 手机号 [ require false ]
     * @support  string $issue_count 发券数目 [ require true ]
     * @support  string $paid_amount 订单金额 [ require true ]
     * @support  string $user_paid_amount 用户实际支付金额 [ require true ]
     * @support  string $platform_discount_amount 平台优惠金额 [ require false ]
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendPreferential () {
        return self::getClass()->sendPreferential([
        ]);
    }

    /**
     * 团购退券
     *
     * @support  string $app_deal_id 第三方团单id [ require true ]
     * @support  string $order_id 开放平台上的订单ID [ require true ]
     * @support  string $refund_id 退款id [ require true ]
     * @support  string $serial_number_list 退券列表,逗号分隔 [ require true ]
     * @support  int $refund_count 退券数目 [ require true ]
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function refundPreferential () {
        return self::getClass()->refundPreferential([
        ]);
    }

    /**
     * 团购强制退券
     *
     * @support  string $app_deal_id 第三方团单id [ require true ]
     * @support  string $order_id 开放平台上的订单ID [ require true ]
     * @support  string $refund_id 退款id [ require true ]
     * @support  string $serial_number_list 退券列表,逗号分隔 [ require true ]
     * @support  int $refund_count 退券数目 [ require true ]
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function forceRefundPreferential () {
        return self::getClass()->forceRefundPreferential([
        ]);
    }

    /**
     * 使用券码通知
     *
     * @support  string $code 券码 [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function usePreferential () {
        return self::getClass()->usePreferential([
        ]);
    }

    /**
     * 获取点评session
     *
     * @support  string $appKey 应用KEY [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSessionForBigData () {
        return self::getClass()->getSessionForBigData([
        ]);
    }

    /**
     * 查询并发送大众点评中差评价数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function ugcNotify () {
        return self::getClass()->ugcNotify();
    }

    /**
     * 清除点评核销码缓存
     *
     * @param  string $receiptCode code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function flushCache (string $receiptCode) {
        return self::getClass()->flushCache([
            "receiptCode" => $receiptCode,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Extend\DaZhongDianPing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Extend\DaZhongDianPing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}