<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateStatusByParams(array $params)
 * @method deleteByParams(array $params)
 */
class HappyPhotoArticle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 文章列表.发现
     *
     * @support  string $startDay 开始日期 [ require false ]
     * @support  string $endDay 结束日期 [ require false ]
     * @support  string $title 标题关键词 [ require false ]
     * @support  string $label 标签 [ require false ]
     * @support  string $status 上下线状态 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 文章添加.发现
     *
     * @support  string $title 标题 [ require true ]
     * @support  string $label 标签 [ require false ]
     * @support  int $sort 排序, 值从大到小排序 [ require false ]
     * @support  string $nodeType 节点类型 [ require false ]
     * @support  string $nodeContent 节点内容 [ require true ]
     * @support  string $coverType 封面类型 [ require false ]
     * @support  array $coverImages 封面图片 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 文章编辑.发现
     *
     * @support  int $id 文章id [ require true ]
     * @support  string $title 标题 [ require false ]
     * @support  string $label 标签 [ require false ]
     * @support  int $sort 排序, 值从大到小排序 [ require false ]
     * @support  string $nodeType 节点类型 [ require false ]
     * @support  string $nodeContent 节点内容 [ require false ]
     * @support  string $coverType 封面类型 [ require false ]
     * @support  array $coverImages 封面图片 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 文章详情.发现
     *
     * @support  int $id 文章id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 文章上下线.发现
     *
     * @support  int $id 文章id [ require true ]
     * @support  string $status 状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStatus () {
        return self::getClass()->updateStatus([
        ]);
    }

    /**
     * 文章删除.发现
     *
     * @support  int $id 文章id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\HappyPhotoArticle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\HappyPhotoArticle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}