<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method addByParams(array $params)
 * @method editByParams(array $params)
 * @method detailByParams(array $params)
 */
class PopupWindowConfiguration {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取弹窗配置列表
     *
     * @support  string $name 弹窗名称 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 新增弹窗配置
     *
     * @support  string $type 弹窗类型 [ require true ]
     * @support  string $name 弹窗名称 [ require true ]
     * @support  string $jump_type 跳转类型 [ require true ]
     * @support  string $jump_value 跳转值 [ require true ]
     * @support  string $scope_type 选择范围 [ require true ]
     * @support  string $scope_value 城市/门店，为空表示全部 require false
     * @support  string $img_path 弹窗图片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 编辑弹窗配置
     *
     * @support  int $id id [ require true ]
     * @support  string $type 弹窗类型 [ require true ]
     * @support  string $name 弹窗名称 [ require true ]
     * @support  string $jump_type 跳转类型 [ require true ]
     * @support  string $jump_value 跳转值 [ require true ]
     * @support  string $scope_type 选择范围 [ require true ]
     * @support  string $scope_value 城市/门店，为空表示全部 require false
     * @support  string $img_path 弹窗图片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit () {
        return self::getClass()->edit();
    }

    /**
     * 获取弹窗配置详情
     *
     * @support  int $id 弹窗名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PopupWindowConfiguration');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PopupWindowConfiguration');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}