<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createMedalSeriesByParams(array $params)
 * @method editMedalSeriesByParams(array $params)
 * @method onOffMedalSeriesByParams(array $params)
 * @method delMedalSeriesByParams(array $params)
 * @method medalSeriesListByParams(array $params)
 * @method getMedalSeriesByParams(array $params)
 * @method createMedalByParams(array $params)
 * @method editMedalByParams(array $params)
 * @method delMedalByParams(array $params)
 * @method onOffMedalByParams(array $params)
 * @method medalDetailByParams(array $params)
 * @method medalListByParams(array $params)
 * @method getMedalsByParams(array $params)
 * @method medalTreeByParams(array $params)
 */
class Medal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 勋章系列-创建勋章系列
     *
     * @support  string $name 系列名称 [ require true ]
     * @support  mixed $sort 排序 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createMedalSeries () {
        return self::getClass()->createMedalSeries();
    }

    /**
     * 勋章系列-编辑勋章系列
     *
     * @support  int $id 系列ID [ require true ]
     * @support  string $name 系列名称 [ require true ]
     * @support  mixed $sort 排序 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function editMedalSeries () {
        return self::getClass()->editMedalSeries();
    }

    /**
     * 勋章系列-上/下线勋章系列
     *
     * @support  int $id 系列ID [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onOffMedalSeries () {
        return self::getClass()->onOffMedalSeries();
    }

    /**
     * 勋章系列-删除勋章系列
     *
     * @support  int $id 系列ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delMedalSeries () {
        return self::getClass()->delMedalSeries();
    }

    /**
     * 勋章系列-勋章系列列表(不分页)
     *
     * @support  string $name 系列名称 require false
     * @support  string $status 状态:on 上线, off 下线, all 全部 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function medalSeriesList () {
        return self::getClass()->medalSeriesList();
    }

    /**
     * 勋章系列-勋章系列列表(分页)
     *
     * @support  string $name 系列名称 require false
     * @support  string $status 状态:on 上线, off 下线, all 全部 require false
     * @support  int $page 分页, default=1 require false
     * @support  int $pageSize 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMedalSeries () {
        return self::getClass()->getMedalSeries();
    }

    /**
     * 勋章-创建勋章
     *
     * @support  string $name 勋章名称 [ require true ]
     * @support  string $type 勋章类型 require false
     * @support  int $rank 勋章等级 require false
     * @support  mixed $sort 排序 require false
     * @support  int $seriesId 系列名称 [ require true ]
     * @support  int $parentId 父级勋章ID require false
     * @support  mixed $content 勋章内容 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createMedal () {
        return self::getClass()->createMedal();
    }

    /**
     * 勋章-编辑勋章
     *
     * @support  int $medalId 勋章ID [ require true ]
     * @support  string $name 勋章名称 [ require true ]
     * @support  string $type 勋章类型 require false
     * @support  int $rank 勋章等级 require false
     * @support  mixed $sort 排序 require false
     * @support  int $seriesId 系列名称 [ require true ]
     * @support  int $parentId 父级勋章ID require false
     * @support  mixed $content 勋章内容 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function editMedal () {
        return self::getClass()->editMedal();
    }

    /**
     * 勋章-删除勋章
     *
     * @support  int $id 勋章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delMedal () {
        return self::getClass()->delMedal();
    }

    /**
     * 勋章-上/下线勋章
     *
     * @support  int $id 勋章ID [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onOffMedal () {
        return self::getClass()->onOffMedal();
    }

    /**
     * 勋章-勋章详情
     *
     * @support  int $id 勋章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function medalDetail () {
        return self::getClass()->medalDetail();
    }

    /**
     * 勋章-勋章列表
     *
     * @support  mixed $seriesId 系列ID require false
     * @support  mixed $parentId 父级ID require false
     * @support  string $medalName 勋章查询 require false
     * @support  string $status 勋章状态 require false
     * @support  int $rank 勋章等级 require false
     * @support  int $page 分页, default=1 require false
     * @support  int $pageSize 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function medalList () {
        return self::getClass()->medalList();
    }

    /**
     * 勋章-勋章列表[不分页]
     *
     * @support  mixed $seriesId 系列ID require false
     * @support  mixed $parentId 父级ID require false
     * @support  string $status 勋章状态 require false
     * @support  int $rank 勋章等级 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMedals () {
        return self::getClass()->getMedals();
    }

    /**
     * 勋章-勋章tree
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function medalTree () {
        return self::getClass()->medalTree();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Medal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Medal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}