<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method copyByParams(array $params)
 * @method deleteByParams(array $params)
 * @method changeStatusByParams(array $params)
 * @method rulesByParams(array $params)
 */
class ReservationLimit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 限流配置列表
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  int $productId 产品id [ require false ]
     * @support  string $startDate 开始时间 [ require false ]
     * @support  string $endDate 结束时间 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 限流配置-新增
     *
     * @support  string $name 规则名称 [ require false ]
     * @support  string $limit_type 限流类型 [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @support  array $store_ids 限流门店 [ require true ]
     * @support  array $product_ids 限流产品 [ require true ]
     * @support  array $limit_config 限流配置 [ require true ]
     * @support  string $status 状态 [ require true ]
     * @support  string $limit_date_type 限制时间类型 [ require true ]
     * @support  string $limit_range_type 时段限流形式 [ require true ]
     * @support  string $limit_start_date 可预约开始时间 [ require false ]
     * @support  string $limit_end_date 可预约结束时间 [ require false ]
     * @support  array $limit_week_day 限流周期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 限流配置-编辑
     *
     * @support  int $id 规则id [ require false ]
     * @support  string $name 规则名称 [ require false ]
     * @support  string $limit_type 限流类型 [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @support  array $store_ids 限流门店 [ require true ]
     * @support  array $product_ids 限流产品 [ require true ]
     * @support  array $limit_config 限流配置 [ require true ]
     * @support  string $status 状态 [ require true ]
     * @support  string $limit_date_type 限制时间类型 [ require true ]
     * @support  string $limit_range_type 时段限流形式 [ require true ]
     * @support  string $limit_start_date 可预约开始时间 [ require false ]
     * @support  string $limit_end_date 可预约结束时间 [ require false ]
     * @support  array $limit_week_day 限流周期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 限流配置-拷贝并新建
     *
     * @param  int $id 规则id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function copy (int $id) {
        return self::getClass()->copy([
            "id" => $id,
        ]);
    }

    /**
     * 限流配置-删除
     *
     * @param  int $id 规则id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 限流配置-上下线
     *
     * @param  int $id 规则id [ require true ]
     * @param  string $status 修改后状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStatus (int $id, string $status) {
        return self::getClass()->changeStatus([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * 获取限流规则
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  array $productIds 产品列表 [ require true ]
     * @support  string $startDate 开始日期 [ require true ]
     * @support  string $endDate 结束日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function rules () {
        return self::getClass()->rules([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ReservationLimit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ReservationLimit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}