<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method upProductByParams(array $params)
 * @method downProductByParams(array $params)
 * @method batchUpProductByParams(array $params)
 * @method batchDownProductByParams(array $params)
 * @method setSellPriceByParams(array $params)
 * @method setTagsByParams(array $params)
 * @method batchSetTagsByParams(array $params)
 * @method getTagStatusByParams(array $params)
 * @method getTagProductListByParams(array $params)
 * @method getProductStoreGroupByParams(array $params)
 * @method setProductStoreGroupByParams(array $params)
 * @method detailByParams(array $params)
 * @method getSkusByProductByParams(array $params)
 * @method deleteProductStoreGroupByParams(array $params)
 * @method updateSkuByParams(array $params)
 * @method getSkuGroupByParams(array $params)
 * @method batchUpdateSkuImageByParams(array $params)
 * @method batchCreateProductByParams(array $params)
 * @method getMessageLogByParams(array $params)
 * @method newTaskByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售产品
     *
     * @support  int $isCombine 是否是组合商品 [ require true ]
     * @support  int $type 1零售商品，2陈列商品，3定制商品 [ require false ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $categoryId 分类ID [ require true ]
     * @support  array $categoryAttrs 商品分类属性 [ require false ]
     * @support  int $brandId 品牌id [ require true ]
     * @support  array $skus 商品skus [ require true ]
     * @support  int $supplierId 供应商id [ require false ]
     * @support  bool $needCheckStock 是否需要盘点 [ require true ]
     * @support  int $onlineSales 预约端销售商品:1 是 0 否 [ require false ]
     * @support  int $offlineSales 门店端销售商品 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑零售产品
     *
     * @support  int $id 产品ID [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $categoryId 分类ID [ require true ]
     * @support  int $brandId 分类ID [ require true ]
     * @support  array $categoryAttrs 产品主图 [ require false ]
     * @support  int $supplierId 供应商id [ require false ]
     * @support  bool $needCheckStock 是否需要盘点 [ require true ]
     * @support  int $onlineSales 预约端销售商品:1 是 0 否 [ require true ]
     * @support  int $offlineSales 门店端销售商品 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 产品分页列表
     *
     * @support  int $type 1零售商品，2陈列商品，3定制商品，4商城定制商品 [ require false ]
     * @support  string $name 名称(模糊查询) [ require false ]
     * @support  int $categoryId 分类ID [ require false ]
     * @support  array $categoryIds 分类ID列表 [ require false ]
     * @support  int $brandId 品牌ID [ require false ]
     * @support  array $status 状态 [ require false ]
     * @support  string $startAt 创建时间 [ require false ]
     * @support  int $onlineSales 预约端1/0 [ require false ]
     * @support  int $offlineSales 门店端1/0 [ require false ]
     * @support  int $needLabel 是否需要展示标签1/0 [ require false ]
     * @support  string $endAt 更新时间 [ require false ]
     * @support  int $page 当前页 [ require false ]
     * @support  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upProduct (int $id) {
        return self::getClass()->upProduct([
            "id" => $id,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function downProduct (int $id) {
        return self::getClass()->downProduct([
            "id" => $id,
        ]);
    }

    /**
     * 批量上架产品
     *
     * @param  array $ids 产品IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpProduct (array $ids) {
        return self::getClass()->batchUpProduct([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量下架产品
     *
     * @param  array $ids 产品IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchDownProduct (array $ids) {
        return self::getClass()->batchDownProduct([
            "ids" => $ids,
        ]);
    }

    /**
     * 配置sku的现价/售价
     *
     * @param  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setSellPrice (array $data) {
        return self::getClass()->setSellPrice([
            "data" => $data,
        ]);
    }

    /**
     * 设置产品标签
     *
     * @param  int $id 产品id [ require true ]
     * @param  array $tags 标签:new新品,major重点,main主推,清货clear [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setTags (int $id, array $tags = []) {
        return self::getClass()->setTags([
            "id" => $id,
            "tags" => $tags,
        ]);
    }

    /**
     * 批量设置产品标签
     *
     * @param  array $ids 产品id列表 [ require true ]
     * @param  array $updateTags 二维数组[标签id,开始时间start_at,结束时间end_at] [ require false ]
     * @param  array $delTags 二维数组[标签id,标签id] [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSetTags (array $ids, array $updateTags = [], array $delTags = []) {
        return self::getClass()->batchSetTags([
            "ids" => $ids,
            "updateTags" => $updateTags,
            "delTags" => $delTags,
        ]);
    }

    /**
     * 获取产品标签状态
     *
     * @param  array $ids 产品id列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTagStatus (array $ids) {
        return self::getClass()->getTagStatus([
            "ids" => $ids,
        ]);
    }

    /**
     * 标签产品列表
     *
     * @support  int $tagId 标签id [ require true ]
     * @support  string $productName 产品名称 [ require false ]
     * @support  string $startAtBegin 生效时间开始 [ require false ]
     * @support  string $startAtEnd 生效时间结束 [ require false ]
     * @support  string $endAtBegin 失效时间开始 [ require false ]
     * @support  string $endAtEnd 失效时间结束 [ require false ]
     * @support  int $page 当前页 [ require false ]
     * @support  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTagProductList () {
        return self::getClass()->getTagProductList([
        ]);
    }

    /**
     * 获取商品门店组信息
     *
     * @param  array $ids 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductStoreGroup (array $ids) {
        return self::getClass()->getProductStoreGroup([
            "ids" => $ids,
        ]);
    }

    /**
     * 设置商品门店组信息
     *
     * @param  array $ids 产品ids [ require true ]
     * @param  array $storeGroupIds 门店组ids [ require false ]
     * @param  array $storeIds 门店ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProductStoreGroup (array $ids, array $storeGroupIds = [], array $storeIds = []) {
        return self::getClass()->setProductStoreGroup([
            "ids" => $ids,
            "storeGroupIds" => $storeGroupIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 根据商品id获取对应的sku信息
     *
     * @param  int $id 商品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByProduct (int $id) {
        return self::getClass()->getSkusByProduct([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品对应门店组
     *
     * @param  int $id 商品id [ require true ]
     * @param  int $groupId 分组id [ require false ]
     * @param  int $storeId 门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteProductStoreGroup (int $id, int $groupId = 0, int $storeId = 0) {
        return self::getClass()->deleteProductStoreGroup([
            "id" => $id,
            "groupId" => $groupId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 修改sku信息
     *
     * @param  int $productId 商品id [ require true ]
     * @param  array $skus sku信息 [ require true ]
     * @param  array $groups 组合sku信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateSku (int $productId, array $skus, array $groups) {
        return self::getClass()->updateSku([
            "productId" => $productId,
            "skus" => $skus,
            "groups" => $groups,
        ]);
    }

    /**
     * 获取组合的sku信息
     *
     * @param  int $relationId sku的关联id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuGroup (int $relationId) {
        return self::getClass()->getSkuGroup([
            "relationId" => $relationId,
        ]);
    }

    /**
     * 批量修改sku图片
     *
     * @param  string $type name,code根据名称,编码匹配 [ require true ]
     * @param  array $info 待匹配的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdateSkuImage (string $type, array $info) {
        return self::getClass()->batchUpdateSkuImage([
            "type" => $type,
            "info" => $info,
        ]);
    }

    /**
     * 批量创建商品
     *
     * @param  array $info 商品信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreateProduct (array $info) {
        return self::getClass()->batchCreateProduct([
            "info" => $info,
        ]);
    }

    /**
     * 获取商品的操作记录
     *
     * @param  int $id 商品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMessageLog (int $id) {
        return self::getClass()->getMessageLog([
            "id" => $id,
        ]);
    }

    /**
     * 零售商品-新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Retail\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Retail\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}