<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createAppealByParams(array $params)
 * @method getAppealByParams(array $params)
 * @method getAppealByPageByParams(array $params)
 * @method appealDetailByParams(array $params)
 * @method auditAppealByParams(array $params)
 * @method modifyAppealByParams(array $params)
 * @method rejectModifyAppealByParams(array $params)
 * @method modifyProblemTagAppealByParams(array $params)
 * @method getProblemTagLikesByParams(array $params)
 * @method likeProblemTagByParams(array $params)
 * @method dislikeProblemTagByParams(array $params)
 * @method problemTagAppealDetailByParams(array $params)
 */
class Appeal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发起申诉
     *
     * @support  string $service_type 业务类型 [ require false ]
     * @support  string $service_id 业务唯一id,例如订单id [ require true ]
     * @support  array $service_content 业务内容 [ require true ]
     * @support  array $appeal_content 申诉内容 [ require true ]
     * @support  string $note 申诉备注 [ require false ]
     * @support  string $remark 问题标签申述备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAppeal ($context) {
        return self::getClass()->createAppeal([
            "context" => $context,
        ]);
    }

    /**
     * 获取申诉
     *
     * @support  string $service_type 业务类型 [ require false ]
     * @support  string $appeal_status 申诉状态 [ require false ]
     * @support  array $input_staff_ids 申请人ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppeal ($context) {
        return self::getClass()->getAppeal([
            "context" => $context,
        ]);
    }

    /**
     * 获取申诉分页
     *
     * @support  string $service_type 业务类型 [ require false ]
     * @support  string $appeal_status 申诉状态 [ require false ]
     * @support  array $input_staff_ids 申请人ids [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppealByPage ($context, int $page = 1, int $page_size = 10) {
        return self::getClass()->getAppealByPage([
            "context" => $context,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取申诉详情
     *
     * @param  int $id 申诉id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appealDetail (int $id) {
        return self::getClass()->appealDetail([
            "id" => $id,
        ]);
    }

    /**
     * 申诉审核
     *
     * @param  int $id 申诉id [ require true ]
     * @param  string $audit_status 审核结果 [ require true ]
     * @support  string $remark 问题标签申述备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function auditAppeal ($context, int $id, string $audit_status) {
        return self::getClass()->auditAppeal([
            "context" => $context,
            "id" => $id,
            "audit_status" => $audit_status,
        ]);
    }

    /**
     * 修改评分
     *
     * @support  int $appeal_id 申诉id [ require true ]
     * @support  string $pool_name 池名称 [ require true ]
     * @support  string $record_id 评价记录id [ require true ]
     * @support  array $modify_info 修改的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyAppeal ($context) {
        return self::getClass()->modifyAppeal([
            "context" => $context,
        ]);
    }

    /**
     * 拒绝修改评分
     *
     * @param  int $id 申诉id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function rejectModifyAppeal (int $id, $context) {
        return self::getClass()->rejectModifyAppeal([
            "id" => $id,
            "context" => $context,
        ]);
    }

    /**
     * 修改问题标签
     *
     * @support  int $appeal_id 申诉id [ require true ]
     * @support  string $appeal_status 申诉状态 [ require true ]
     * @support  string $remark 问题申诉备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyProblemTagAppeal ($context) {
        return self::getClass()->modifyProblemTagAppeal([
            "context" => $context,
        ]);
    }

    /**
     * 获取当前用户点赞的标签
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProblemTagLikes ($context) {
        return self::getClass()->getProblemTagLikes([
            "context" => $context,
        ]);
    }

    /**
     * 点赞问题标签
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @support  string $order_no 订单号 [ require true ]
     * @support  int $problem_tag_id 问题标签id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function likeProblemTag ($context) {
        return self::getClass()->likeProblemTag([
            "context" => $context,
        ]);
    }

    /**
     * 取消点赞问题标签
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @support  int $problem_tag_id 问题标签id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dislikeProblemTag ($context) {
        return self::getClass()->dislikeProblemTag([
            "context" => $context,
        ]);
    }

    /**
     * 获取问题标签申诉详情
     *
     * @support  string $service_id 业务唯一id,例如订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function problemTagAppealDetail ($context) {
        return self::getClass()->problemTagAppealDetail([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Appeal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Appeal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}