<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrEditAppByParams(array $params)
 * @method getAppDetailByParams(array $params)
 * @method getAppListByParams(array $params)
 * @method getAppListByPageByParams(array $params)
 * @method deleteAppByParams(array $params)
 */
class Application {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建应用
     *
     * @support  string $appNo 应用No [ require true ]
     * @support  string $appName 应用名 [ require true ]
     * @support  string $appMd5 应用md5 [ require true ]
     * @support  string $asarDownUrl 下载地址 [ require true ]
     * @support  string $appIcon 图标 [ require true ]
     * @support  string $backgroundUrl 背景 [ require false ]
     * @support  string $themeColor 主题色 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrEditApp ($context) {
        return self::getClass()->createOrEditApp([
            "context" => $context,
        ]);
    }

    /**
     * 获取应用详情
     *
     * @param  string $appNo 应用编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppDetail (string $appNo) {
        return self::getClass()->getAppDetail([
            "appNo" => $appNo,
        ]);
    }

    /**
     * 获取应用列表(全部)
     *
     * @support  string $status 应用状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppList ($context) {
        return self::getClass()->getAppList([
            "context" => $context,
        ]);
    }

    /**
     * 获取应用列表(分页)
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @support  string $status 应用状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppListByPage ($context) {
        return self::getClass()->getAppListByPage([
            "context" => $context,
        ]);
    }

    /**
     * 下架应用
     *
     * @param  string $appNo 应用编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteApp (string $appNo) {
        return self::getClass()->deleteApp([
            "appNo" => $appNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Application');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Application');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}