<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method infoByParams(array $params)
 * @method listByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getMaterialListByParams(array $params)
 * @method getKidsKeyWordsByParams(array $params)
 */
class Keyword {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增关键词
     *
     * @param  string $title 标题 [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @param  string $keyword 关键词 [ require true ]
     * @param  array $body 回复内容 [ require true ]
     * @param  string $start 上线时间 [ require false ]
     * @param  string $end 下线时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add (string $title, string $brand, string $keyword, array $body, string $start = '2038-01-19 11:14:07', string $end = '2038-01-19 11:14:07') {
        return self::getClass()->add([
            "title" => $title,
            "brand" => $brand,
            "keyword" => $keyword,
            "body" => $body,
            "start" => $start,
            "end" => $end,
        ]);
    }

    /**
     * 单个关键词信息
     *
     * @param  int $id 关键词id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * 查询关键词
     *
     * @support  string $brand 品牌 [ require false ]
     * @support  string $title 标题 [ require false ]
     * @support  string $keyword 关键词 [ require false ]
     * @support  string $title_keyword 标题||关键词 [ require false ]
     * @support  bool $is_released 是否上线 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 更新关键词信息
     *
     * @param  int $id 关键词id [ require true ]
     * @param  string $title 标题 [ require false ]
     * @param  string $brand 品牌(himo,mantu,himo_kids,himo_lens,himo_business,himo_gold,show_pic_wx,mantu_beauty) [ require false ]
     * @param  string $keyword 关键词 [ require false ]
     * @param  array $body 回复内容 [ require false ]
     * @param  string $start 上线时间 [ require false ]
     * @param  string $end 下线时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, string $title = '', string $brand = '', string $keyword = '', array $body = [], string $start = '', string $end = '') {
        return self::getClass()->update([
            "id" => $id,
            "title" => $title,
            "brand" => $brand,
            "keyword" => $keyword,
            "body" => $body,
            "start" => $start,
            "end" => $end,
        ]);
    }

    /**
     * 删除关键词
     *
     * @param  int $id 关键词id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取永久素材列表
     *
     * @param  string $app_name 应用名称 [ require true ]
     * @param  string $type 素材类型(image,video,voice,news) [ require true ]
     * @param  int $offset 从该偏移位置开始返回 [ require false ]
     * @param  int $count 返回素材的数量(1-20) [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialList (string $app_name, string $type, int $offset = 0, int $count = 20) {
        return self::getClass()->getMaterialList([
            "app_name" => $app_name,
            "type" => $type,
            "offset" => $offset,
            "count" => $count,
        ]);
    }

    /**
     * 获取kids关键字
     *
     * @support  string $token token [ require true ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getKidsKeyWords ($context) {
        return self::getClass()->getKidsKeyWords([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Keyword');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Keyword');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}